/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexCentricQueryBuilder
extends BasicVertexCentricQueryBuilder<VertexCentricQueryBuilder>
implements TitanVertexQuery<VertexCentricQueryBuilder> {
    private static final Logger log = LoggerFactory.getLogger(VertexCentricQueryBuilder.class);
    private final InternalVertex vertex;

    public VertexCentricQueryBuilder(InternalVertex v) {
        super(v.tx());
        Preconditions.checkNotNull((Object)v);
        this.vertex = v;
    }

    @Override
    protected VertexCentricQueryBuilder getThis() {
        return this;
    }

    protected <Q> Q execute(RelationCategory returnType, BasicVertexCentricQueryBuilder.ResultConstructor<Q> resultConstructor) {
        BaseVertexCentricQuery bq = super.constructQuery(returnType);
        if (bq.isEmpty()) {
            return resultConstructor.emptyResult();
        }
        if (returnType == RelationCategory.PROPERTY && this.hasSingleType() && !this.hasQueryOnlyLoaded() && this.tx.getConfiguration().hasPropertyPrefetching()) {
            this.vertex.query().properties().iterator().hasNext();
        }
        if (this.isPartitionedVertex(this.vertex) && !this.hasQueryOnlyGivenVertex()) {
            List<InternalVertex> vertices = this.allRequiredRepresentatives(this.vertex);
            this.profiler.setAnnotation("partitioned", true);
            this.profiler.setAnnotation("vertices", vertices.size());
            if (vertices.size() > 1) {
                for (BackendQueryHolder<SliceQuery> sq : bq.getQueries()) {
                    this.tx.executeMultiQuery(vertices, sq.getBackendQuery(), sq.getProfiler());
                }
            }
        } else {
            this.profiler.setAnnotation("vertices", 1);
        }
        return resultConstructor.getResult(this.vertex, bq);
    }

    @Override
    public Iterable<TitanEdge> edges() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<TitanVertexProperty> properties() {
        return this.isImplicitKeyQuery(RelationCategory.PROPERTY) ? this.executeImplicitKeyQuery(this.vertex) : this.execute(RelationCategory.PROPERTY, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<TitanRelation> relations() {
        return this.isImplicitKeyQuery(RelationCategory.RELATION) ? this.executeImplicitKeyQuery(this.vertex) : this.execute(RelationCategory.RELATION, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<TitanVertex> vertices() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexConstructor(this));
    }

    @Override
    public VertexList vertexIds() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexIdConstructor(this));
    }
}

