/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Contain;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;

public interface TitanPredicate
extends BiPredicate<Object, Object> {
    public boolean isValidCondition(Object var1);

    public boolean isValidValueType(Class<?> var1);

    public boolean hasNegation();

    public TitanPredicate negate();

    public boolean isQNF();

    @Override
    public boolean test(Object var1, Object var2);

    public static class Converter {
        public static final TitanPredicate convertInternal(BiPredicate p) {
            if (p instanceof TitanPredicate) {
                return (TitanPredicate)p;
            }
            if (p instanceof Compare) {
                Compare comp = (Compare)p;
                switch (comp) {
                    case eq: {
                        return Cmp.EQUAL;
                    }
                    case neq: {
                        return Cmp.NOT_EQUAL;
                    }
                    case gt: {
                        return Cmp.GREATER_THAN;
                    }
                    case gte: {
                        return Cmp.GREATER_THAN_EQUAL;
                    }
                    case lt: {
                        return Cmp.LESS_THAN;
                    }
                    case lte: {
                        return Cmp.LESS_THAN_EQUAL;
                    }
                }
                throw new IllegalArgumentException("Unexpected comparator: " + comp);
            }
            if (p instanceof Contains) {
                Contains con = (Contains)p;
                switch (con) {
                    case within: {
                        return Contain.IN;
                    }
                    case without: {
                        return Contain.NOT_IN;
                    }
                }
                throw new IllegalArgumentException("Unexpected container: " + con);
            }
            return null;
        }

        public static final TitanPredicate convert(BiPredicate p) {
            TitanPredicate titanPred = Converter.convertInternal(p);
            if (titanPred == null) {
                throw new IllegalArgumentException("Titan does not support the given predicate: " + p);
            }
            return titanPred;
        }

        public static final boolean supports(BiPredicate p) {
            return Converter.convertInternal(p) != null;
        }
    }
}

