/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap.job;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.management.RelationTypeIndexWrapper;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.olap.QueryContainer;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.graphdb.olap.job.IndexUpdateJob;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class IndexRepairJob
extends IndexUpdateJob
implements VertexScanJob {
    public static final String ADDED_RECORDS_COUNT = "adds";
    public static final String DOCUMENT_UPDATES_COUNT = "doc-updates";

    public IndexRepairJob() {
    }

    protected IndexRepairJob(IndexRepairJob job) {
        super(job);
    }

    public IndexRepairJob(String indexName, String indexType) {
        super(indexName, indexType);
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        super.workerIterationEnd(metrics);
    }

    @Override
    public void workerIterationStart(TitanGraph graph, Configuration config, ScanMetrics metrics) {
        super.workerIterationStart(graph, config, metrics);
    }

    @Override
    protected void validateIndexStatus() {
        String invalidIndexHint;
        TitanSchemaVertex schemaVertex = this.mgmt.getSchemaVertex(this.index);
        Set<SchemaStatus> acceptableStatuses = SchemaAction.REINDEX.getApplicableStatus();
        boolean isValidIndex = true;
        if (this.index instanceof RelationTypeIndex || this.index instanceof TitanGraphIndex && ((TitanGraphIndex)this.index).isCompositeIndex()) {
            SchemaStatus actualStatus = schemaVertex.getStatus();
            isValidIndex = acceptableStatuses.contains((Object)actualStatus);
            invalidIndexHint = String.format("The index has status %s, but one of %s is required", new Object[]{actualStatus, acceptableStatuses});
        } else {
            Preconditions.checkArgument((boolean)(this.index instanceof TitanGraphIndex), (String)"Unexpected index: %s", (Object[])new Object[]{this.index});
            TitanGraphIndex gindex = (TitanGraphIndex)this.index;
            Preconditions.checkArgument((boolean)gindex.isMixedIndex());
            HashMap<String, SchemaStatus> invalidKeyStatuses = new HashMap<String, SchemaStatus>();
            int acceptableFields = 0;
            for (PropertyKey key : gindex.getFieldKeys()) {
                SchemaStatus status = gindex.getIndexStatus(key);
                if (status != SchemaStatus.DISABLED && !acceptableStatuses.contains((Object)status)) {
                    isValidIndex = false;
                    invalidKeyStatuses.put(key.name(), status);
                    log.warn("Index {} has key {} in an invalid status {}", new Object[]{this.index, key, status});
                }
                if (!acceptableStatuses.contains((Object)status)) continue;
                ++acceptableFields;
            }
            invalidIndexHint = String.format("The following index keys have invalid status: %s (status must be one of %s)", Joiner.on((String)",").withKeyValueSeparator(" has status ").join(invalidKeyStatuses), acceptableStatuses);
            if (isValidIndex && acceptableFields == 0) {
                isValidIndex = false;
                invalidIndexHint = "The index does not contain any valid keys";
            }
        }
        Preconditions.checkArgument((boolean)isValidIndex, (String)"The index %s is in an invalid state and cannot be indexed. %s", (Object[])new Object[]{this.indexName, invalidIndexHint});
        log.debug("Index {} is valid for re-indexing");
    }

    @Override
    public void process(TitanVertex vertex, ScanMetrics metrics) {
        block20: {
            try {
                BackendTransaction mutator = this.writeTx.getTxHandle();
                if (this.index instanceof RelationTypeIndex) {
                    RelationTypeIndexWrapper wrapper = (RelationTypeIndexWrapper)this.index;
                    InternalRelationType wrappedType = wrapper.getWrappedType();
                    EdgeSerializer edgeSerializer = this.writeTx.getEdgeSerializer();
                    ArrayList<Entry> additions = new ArrayList<Entry>();
                    for (TitanRelation relation : vertex.query().types(new String[]{this.indexRelationTypeName}).direction(Direction.OUT).relations()) {
                        InternalRelation titanRelation = (InternalRelation)relation;
                        for (int pos = 0; pos < titanRelation.getArity(); ++pos) {
                            if (!wrappedType.isUnidirected(Direction.BOTH) && !wrappedType.isUnidirected(EdgeDirection.fromPosition(pos))) continue;
                            StaticArrayEntry entry = edgeSerializer.writeRelation(titanRelation, wrappedType, pos, this.writeTx);
                            additions.add(entry);
                        }
                    }
                    StaticBuffer vertexKey = this.writeTx.getIdInspector().getKey(vertex.longId());
                    mutator.mutateEdges(vertexKey, additions, KCVSCache.NO_DELETIONS);
                    metrics.incrementCustom(ADDED_RECORDS_COUNT, additions.size());
                    break block20;
                }
                if (this.index instanceof TitanGraphIndex) {
                    ArrayList elements;
                    IndexType indexType = this.mgmt.getSchemaVertex(this.index).asIndexType();
                    assert (indexType != null);
                    IndexSerializer indexSerializer = this.graph.getIndexSerializer();
                    switch (indexType.getElement()) {
                        case VERTEX: {
                            elements = ImmutableList.of((Object)vertex);
                            break;
                        }
                        case PROPERTY: {
                            elements = Lists.newArrayList();
                            for (TitanVertexProperty p : IndexRepairJob.addIndexSchemaConstraint(vertex.query(), indexType).properties()) {
                                elements.add(p);
                            }
                            break;
                        }
                        case EDGE: {
                            elements = Lists.newArrayList();
                            for (TitanEdge e : ((TitanVertexQuery)IndexRepairJob.addIndexSchemaConstraint(vertex.query().direction(Direction.OUT), indexType)).edges()) {
                                elements.add(e);
                            }
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected category: " + (Object)((Object)indexType.getElement())));
                        }
                    }
                    if (indexType.isCompositeIndex()) {
                        for (TitanElement element : elements) {
                            Set<IndexSerializer.IndexUpdate<StaticBuffer, Entry>> updates = indexSerializer.reindexElement(element, (CompositeIndexType)indexType);
                            for (IndexSerializer.IndexUpdate<StaticBuffer, Entry> update : updates) {
                                log.debug("Mutating index {}: {}", (Object)indexType, (Object)update.getEntry());
                                mutator.mutateIndex(update.getKey(), Lists.newArrayList((Object[])new Entry[]{update.getEntry()}), KCVSCache.NO_DELETIONS);
                                metrics.incrementCustom(ADDED_RECORDS_COUNT);
                            }
                        }
                    } else {
                        assert (indexType.isMixedIndex());
                        HashMap<String, Map<String, List<IndexEntry>>> documentsPerStore = new HashMap<String, Map<String, List<IndexEntry>>>();
                        for (TitanElement element : elements) {
                            indexSerializer.reindexElement(element, (MixedIndexType)indexType, documentsPerStore);
                            metrics.incrementCustom(DOCUMENT_UPDATES_COUNT);
                        }
                        mutator.getIndexTransaction(indexType.getBackingIndexName()).restore(documentsPerStore);
                    }
                    break block20;
                }
                throw new UnsupportedOperationException("Unsupported index found: " + this.index);
            }
            catch (Exception e) {
                this.mgmt.rollback();
                this.writeTx.rollback();
                metrics.incrementCustom("failed-tx");
                throw new TitanException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void getQueries(QueryContainer queries) {
        if (this.index instanceof RelationTypeIndex) {
            ((QueryContainer.QueryBuilder)queries.addQuery().types(this.indexRelationTypeName)).direction(Direction.OUT).relations();
        } else if (this.index instanceof TitanGraphIndex) {
            IndexType indexType = this.mgmt.getSchemaVertex(this.index).asIndexType();
            switch (indexType.getElement()) {
                case PROPERTY: {
                    IndexRepairJob.addIndexSchemaConstraint(queries.addQuery(), indexType).properties();
                    break;
                }
                case VERTEX: {
                    queries.addQuery().properties();
                    queries.addQuery().type(BaseLabel.VertexLabelEdge).direction(Direction.OUT).edges();
                    break;
                }
                case EDGE: {
                    indexType.hasSchemaTypeConstraint();
                    IndexRepairJob.addIndexSchemaConstraint(queries.addQuery().direction(Direction.OUT), indexType).edges();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected category: " + (Object)((Object)indexType.getElement())));
                }
            }
        } else {
            throw new UnsupportedOperationException("Unsupported index found: " + this.index);
        }
    }

    @Override
    public IndexRepairJob clone() {
        return new IndexRepairJob(this);
    }

    private static <Q extends BaseVertexQuery> Q addIndexSchemaConstraint(Q query, IndexType indexType) {
        if (indexType.hasSchemaTypeConstraint()) {
            TitanSchemaType constraint = indexType.getSchemaTypeConstraint();
            Preconditions.checkArgument((boolean)(constraint instanceof RelationType), (String)"Expected constraint to be a relation type: %s", (Object[])new Object[]{constraint});
            query.types((RelationType)constraint);
        }
        return query;
    }
}

