/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.management.RelationTypeIndexWrapper;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.olap.QueryContainer;
import com.thinkaurelius.titan.graphdb.olap.VertexJobConverter;
import com.thinkaurelius.titan.graphdb.olap.job.IndexUpdateJob;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class IndexRemoveJob
extends IndexUpdateJob
implements ScanJob {
    private final VertexJobConverter.GraphProvider graph = new VertexJobConverter.GraphProvider();
    public static final String DELETED_RECORDS_COUNT = "deletes";
    private IndexSerializer indexSerializer;
    private long graphIndexId;
    private IDManager idManager;

    public IndexRemoveJob() {
    }

    protected IndexRemoveJob(IndexRemoveJob copy) {
        super(copy);
        if (copy.graph.isProvided()) {
            this.graph.setGraph(copy.graph.get());
        }
    }

    public IndexRemoveJob(TitanGraph graph, String indexName, String indexType) {
        super(indexName, indexType);
        this.graph.setGraph(graph);
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        super.workerIterationEnd(metrics);
        this.graph.close();
    }

    @Override
    public void workerIterationStart(Configuration config, Configuration graphConf, ScanMetrics metrics) {
        this.graph.initializeGraph(graphConf);
        this.indexSerializer = this.graph.get().getIndexSerializer();
        this.idManager = this.graph.get().getIDManager();
        try {
            super.workerIterationStart(this.graph.get(), config, metrics);
        }
        catch (Throwable e) {
            this.graph.close();
            throw e;
        }
    }

    @Override
    protected void validateIndexStatus() {
        TitanSchemaVertex schemaVertex;
        SchemaStatus actualStatus;
        if (!(this.index instanceof RelationTypeIndex)) {
            if (this.index instanceof TitanGraphIndex) {
                TitanGraphIndex gindex = (TitanGraphIndex)this.index;
                if (gindex.isMixedIndex()) {
                    throw new UnsupportedOperationException("Cannot remove mixed indexes through Titan. This can only be accomplished in the indexing system directly.");
                }
                CompositeIndexType indexType = (CompositeIndexType)this.mgmt.getSchemaVertex(this.index).asIndexType();
                this.graphIndexId = indexType.getID();
            } else {
                throw new UnsupportedOperationException("Unsupported index found: " + this.index);
            }
        }
        Preconditions.checkArgument(((actualStatus = (schemaVertex = this.mgmt.getSchemaVertex(this.index)).getStatus()) == SchemaStatus.DISABLED ? 1 : 0) != 0, (String)"The index [%s] must be disabled before it can be removed", (Object[])new Object[]{this.indexName});
    }

    @Override
    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        try {
            ArrayList<Entry> deletions;
            BackendTransaction mutator = this.writeTx.getTxHandle();
            if (entries.size() == 1) {
                deletions = (ArrayList<Entry>)Iterables.getOnlyElement(entries.values());
            } else {
                int size = IteratorUtils.stream(entries.values().iterator()).map(e -> e.size()).reduce(0, (x, y) -> x + y);
                deletions = new ArrayList<Entry>(size);
                entries.values().forEach(e -> deletions.addAll((Collection<Entry>)e));
            }
            metrics.incrementCustom(DELETED_RECORDS_COUNT, deletions.size());
            if (this.isRelationTypeIndex()) {
                mutator.mutateEdges(key, KCVSCache.NO_ADDITIONS, deletions);
            } else {
                mutator.mutateIndex(key, KCVSCache.NO_ADDITIONS, deletions);
            }
        }
        catch (Exception e2) {
            this.mgmt.rollback();
            this.writeTx.rollback();
            metrics.incrementCustom("failed-tx");
            throw new TitanException(e2.getMessage(), e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SliceQuery> getQueries() {
        if (this.isGlobalGraphIndex()) {
            return ImmutableList.of((Object)new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(128)));
        }
        RelationTypeIndexWrapper wrapper = (RelationTypeIndexWrapper)this.index;
        InternalRelationType wrappedType = wrapper.getWrappedType();
        Direction direction = null;
        for (Direction dir : Direction.values()) {
            if (!wrappedType.isUnidirected(dir)) continue;
            direction = dir;
        }
        assert (direction != null);
        StandardTitanTx tx = (StandardTitanTx)this.graph.get().buildTransaction().readOnly().start();
        try {
            QueryContainer qc = new QueryContainer(tx);
            qc.addQuery().type(wrappedType).direction(direction).relations();
            List<SliceQuery> list = qc.getSliceQueries();
            return list;
        }
        finally {
            tx.rollback();
        }
    }

    @Override
    public Predicate<StaticBuffer> getKeyFilter() {
        if (this.isGlobalGraphIndex()) {
            assert (this.graphIndexId > 0L);
            return k -> {
                try {
                    return this.indexSerializer.getIndexIdFromKey((StaticBuffer)k) == this.graphIndexId;
                }
                catch (RuntimeException e) {
                    log.error("Filtering key {} due to exception", k, (Object)e);
                    return false;
                }
            };
        }
        return buffer -> {
            long vertexId = this.idManager.getKeyID((StaticBuffer)buffer);
            return !IDManager.VertexIDType.Invisible.is(vertexId);
        };
    }

    @Override
    public IndexRemoveJob clone() {
        return new IndexRemoveJob(this);
    }
}

