/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap.computer;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.idhandling.IDHandler;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.olap.QueryContainer;
import com.thinkaurelius.titan.graphdb.olap.VertexJobConverter;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraMemory;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraUtil;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraVertexMemory;
import com.thinkaurelius.titan.graphdb.olap.computer.VertexMemoryHandler;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanVertexStep;
import com.thinkaurelius.titan.graphdb.vertices.PreloadedVertex;
import java.util.Iterator;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexProgramScanJob<M>
implements VertexScanJob {
    private static final Logger log = LoggerFactory.getLogger(VertexProgramScanJob.class);
    private final IDManager idManager;
    private final FulgoraMemory memory;
    private final FulgoraVertexMemory<M> vertexMemory;
    private final VertexProgram<M> vertexProgram;
    private final MessageCombiner<M> combiner;
    static final SliceQuery SYSTEM_PROPS_QUERY = new SliceQuery(IDHandler.getBounds(RelationCategory.PROPERTY, true)[0], IDHandler.getBounds(RelationCategory.PROPERTY, false)[1]);

    private VertexProgramScanJob(IDManager idManager, FulgoraMemory memory, FulgoraVertexMemory vertexMemory, VertexProgram<M> vertexProgram) {
        this.idManager = idManager;
        this.memory = memory;
        this.vertexMemory = vertexMemory;
        this.vertexProgram = vertexProgram;
        this.combiner = FulgoraUtil.getMessageCombiner(vertexProgram);
    }

    @Override
    public VertexProgramScanJob<M> clone() {
        return new VertexProgramScanJob<M>(this.idManager, this.memory, this.vertexMemory, this.vertexProgram.clone());
    }

    @Override
    public void workerIterationStart(TitanGraph graph, Configuration config, ScanMetrics metrics) {
        this.vertexProgram.workerIterationStart(this.memory.asImmutable());
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        this.vertexProgram.workerIterationEnd(this.memory.asImmutable());
    }

    @Override
    public void process(TitanVertex vertex, ScanMetrics metrics) {
        PreloadedVertex v = (PreloadedVertex)vertex;
        long vertexId = v.longId();
        VertexMemoryHandler<M> vh = new VertexMemoryHandler<M>(this.vertexMemory, v);
        v.setAccessCheck(PreloadedVertex.OPENSTAR_CHECK);
        if (this.idManager.isPartitionedVertex(vertexId)) {
            if (this.idManager.isCanonicalVertexId(vertexId)) {
                EntryList results = v.getFromCache(SYSTEM_PROPS_QUERY);
                if (results == null) {
                    results = EntryList.EMPTY_LIST;
                }
                this.vertexMemory.setLoadedProperties(vertexId, results);
            }
            for (MessageScope scope : this.vertexMemory.getPreviousScopes()) {
                if (!(scope instanceof MessageScope.Local)) continue;
                Object combinedMsg = null;
                Iterator msgIter = vh.receiveMessages(scope).iterator();
                while (msgIter.hasNext()) {
                    Object msg = msgIter.next();
                    if (combinedMsg == null) {
                        combinedMsg = msg;
                        continue;
                    }
                    combinedMsg = this.combiner.combine(combinedMsg, msg);
                }
                if (combinedMsg == null) continue;
                this.vertexMemory.aggregateMessage(vertexId, combinedMsg, scope);
            }
        } else {
            v.setPropertyMixing(vh);
            this.vertexProgram.execute((Vertex)v, vh, (Memory)this.memory);
        }
    }

    @Override
    public void getQueries(QueryContainer queries) {
        if (this.vertexProgram instanceof TraversalVertexProgram) {
            queries.addQuery().direction(Direction.BOTH).edges();
            return;
        }
        for (MessageScope scope : this.vertexMemory.getPreviousScopes()) {
            if (scope instanceof MessageScope.Global) {
                queries.addQuery().direction(Direction.BOTH).edges();
                continue;
            }
            assert (scope instanceof MessageScope.Local);
            TitanVertexStep<Vertex> startStep = FulgoraUtil.getReverseTitanVertexStep((MessageScope.Local)scope, queries.getTransaction());
            QueryContainer.QueryBuilder qb = queries.addQuery();
            startStep.makeQuery(qb);
            qb.edges();
        }
    }

    public static <M> Executor getVertexProgramScanJob(StandardTitanGraph graph, FulgoraMemory memory, FulgoraVertexMemory vertexMemory, VertexProgram<M> vertexProgram) {
        VertexProgramScanJob<M> job = new VertexProgramScanJob<M>(graph.getIDManager(), memory, vertexMemory, vertexProgram);
        return new Executor(graph, job);
    }

    public static class Executor
    extends VertexJobConverter {
        private Executor(TitanGraph graph, VertexProgramScanJob job) {
            super(graph, job);
        }

        private Executor(Executor copy) {
            super(copy);
        }

        @Override
        public List<SliceQuery> getQueries() {
            List<SliceQuery> queries = super.getQueries();
            queries.add(SYSTEM_PROPS_QUERY);
            return queries;
        }

        @Override
        public void workerIterationEnd(ScanMetrics metrics) {
            super.workerIterationEnd(metrics);
        }

        @Override
        public Executor clone() {
            return new Executor(this);
        }
    }
}

