/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanJob;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.olap.QueryContainer;
import com.thinkaurelius.titan.graphdb.olap.VertexScanJob;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.transaction.StandardTransactionBuilder;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.vertices.PreloadedVertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexJobConverter
implements ScanJob {
    private static final Logger log = LoggerFactory.getLogger(VertexJobConverter.class);
    protected static final SliceQuery VERTEX_EXISTS_QUERY = new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(4)).setLimit(1);
    public static final String GHOST_VERTEX_COUNT = "ghost-vertices";
    public static final String TRUNCATED_ENTRY_LISTS = "truncated-results";
    protected final GraphProvider graph;
    protected final VertexScanJob job;
    protected StandardTitanTx tx;
    private IDManager idManager;

    protected VertexJobConverter(TitanGraph graph, VertexScanJob job) {
        Preconditions.checkArgument((job != null ? 1 : 0) != 0);
        this.graph = new GraphProvider();
        if (graph != null) {
            this.graph.setGraph(graph);
        }
        this.job = job;
    }

    protected VertexJobConverter(VertexJobConverter copy) {
        this.graph = new GraphProvider();
        if (copy.graph.isProvided()) {
            this.graph.setGraph(copy.graph.get());
        }
        this.job = copy.job.clone();
    }

    public static ScanJob convert(TitanGraph graph, VertexScanJob vertexJob) {
        return new VertexJobConverter(graph, vertexJob);
    }

    public static ScanJob convert(VertexScanJob vertexJob) {
        return new VertexJobConverter(null, vertexJob);
    }

    public static StandardTitanTx startTransaction(StandardTitanGraph graph) {
        StandardTransactionBuilder txb = graph.buildTransaction().readOnly();
        txb.setPreloadedData(true);
        txb.checkInternalVertexExistence(false);
        txb.dirtyVertexSize(0);
        txb.vertexCacheSize(0);
        return (StandardTitanTx)txb.start();
    }

    @Override
    public void workerIterationStart(Configuration jobConfig, Configuration graphConfig, ScanMetrics metrics) {
        this.graph.initializeGraph(graphConfig);
        this.idManager = this.graph.get().getIDManager();
        try {
            this.tx = VertexJobConverter.startTransaction(this.graph.get());
            this.job.workerIterationStart(this.graph.get(), jobConfig, metrics);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    private void close() {
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.rollback();
        }
        this.graph.close();
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        this.job.workerIterationEnd(metrics);
        this.close();
    }

    @Override
    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        long vertexId = this.getVertexId(key);
        assert (entries.get(VERTEX_EXISTS_QUERY) != null);
        if (this.isGhostVertex(vertexId, entries.get(VERTEX_EXISTS_QUERY))) {
            metrics.incrementCustom(GHOST_VERTEX_COUNT);
            return;
        }
        InternalVertex vertex = this.tx.getInternalVertex(vertexId);
        Preconditions.checkArgument((boolean)(vertex instanceof PreloadedVertex), (Object)"The bounding transaction is not configured correctly");
        PreloadedVertex v = (PreloadedVertex)vertex;
        v.setAccessCheck(PreloadedVertex.OPENSTAR_CHECK);
        for (Map.Entry<SliceQuery, EntryList> entry : entries.entrySet()) {
            SliceQuery sq = entry.getKey();
            if (sq.equals(VERTEX_EXISTS_QUERY)) continue;
            EntryList entryList = entry.getValue();
            if (entryList.size() >= sq.getLimit()) {
                metrics.incrementCustom(TRUNCATED_ENTRY_LISTS);
            }
            v.addToQueryCache(sq.updateLimit(Integer.MAX_VALUE), entryList);
        }
        this.job.process(v, metrics);
    }

    protected boolean isGhostVertex(long vertexId, EntryList firstEntries) {
        if (this.idManager.isPartitionedVertex(vertexId) && !this.idManager.isCanonicalVertexId(vertexId)) {
            return false;
        }
        RelationCache relCache = this.tx.getEdgeSerializer().parseRelation((Entry)firstEntries.get(0), true, this.tx);
        return relCache.typeId != BaseKey.VertexExists.longId();
    }

    @Override
    public List<SliceQuery> getQueries() {
        try {
            QueryContainer qc = new QueryContainer(this.tx);
            this.job.getQueries(qc);
            ArrayList<SliceQuery> slices = new ArrayList<SliceQuery>();
            slices.add(VERTEX_EXISTS_QUERY);
            slices.addAll(qc.getSliceQueries());
            return slices;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public Predicate<StaticBuffer> getKeyFilter() {
        return buffer -> {
            long vertexId = this.getVertexId((StaticBuffer)buffer);
            return !IDManager.VertexIDType.Invisible.is(vertexId);
        };
    }

    @Override
    public VertexJobConverter clone() {
        return new VertexJobConverter(this);
    }

    protected long getVertexId(StaticBuffer key) {
        return this.idManager.getKeyID(key);
    }

    public static class GraphProvider {
        private StandardTitanGraph graph = null;
        private boolean provided = false;

        public void setGraph(TitanGraph graph) {
            Preconditions.checkArgument((graph != null && graph.isOpen() ? 1 : 0) != 0, (Object)"Need to provide open graph");
            this.graph = (StandardTitanGraph)graph;
            this.provided = true;
        }

        public void initializeGraph(Configuration config) {
            if (!this.provided) {
                this.graph = (StandardTitanGraph)TitanFactory.open((BasicConfiguration)config);
            }
        }

        public void close() {
            if (!this.provided && null != this.graph && this.graph.isOpen()) {
                this.graph.close();
                this.graph = null;
            }
        }

        public boolean isProvided() {
            return this.provided;
        }

        public final StandardTitanGraph get() {
            Preconditions.checkState((this.graph != null ? 1 : 0) != 0);
            return this.graph;
        }
    }
}

