/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.log;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.log.Change;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.graphdb.database.log.TransactionLogHeader;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractTypedRelation;
import com.thinkaurelius.titan.graphdb.relations.CacheEdge;
import com.thinkaurelius.titan.graphdb.relations.CacheVertexProperty;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.relations.StandardEdge;
import com.thinkaurelius.titan.graphdb.relations.StandardVertexProperty;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class ModificationDeserializer {
    public static InternalRelation parseRelation(TransactionLogHeader.Modification modification, StandardTitanTx tx) {
        AbstractTypedRelation rel;
        Change state = modification.state;
        assert (state.isProper());
        long outVertexId = modification.outVertexId;
        Entry relEntry = modification.relationEntry;
        InternalVertex outVertex = tx.getInternalVertex(outVertexId);
        RelationCache relCache = tx.getEdgeSerializer().readRelation(relEntry, false, tx);
        assert (relCache.direction == Direction.OUT);
        InternalRelationType type = (InternalRelationType)tx.getExistingRelationType(relCache.typeId);
        assert (type.getBaseType() == null);
        if (type.isPropertyKey()) {
            rel = state == Change.REMOVED ? new StandardVertexProperty(relCache.relationId, (PropertyKey)((Object)type), outVertex, relCache.getValue(), 6) : new CacheVertexProperty(relCache.relationId, (PropertyKey)((Object)type), outVertex, relCache.getValue(), relEntry);
        } else {
            assert (type.isEdgeLabel());
            InternalVertex otherVertex = tx.getInternalVertex(relCache.getOtherVertexId());
            rel = state == Change.REMOVED ? new StandardEdge(relCache.relationId, (EdgeLabel)((Object)type), outVertex, otherVertex, 6) : new CacheEdge(relCache.relationId, (EdgeLabel)((Object)type), outVertex, otherVertex, relEntry);
        }
        if (state == Change.REMOVED && relCache.hasProperties()) {
            for (LongObjectCursor<Object> entry : relCache) {
                rel.setPropertyDirect(tx.getExistingPropertyKey(entry.key), entry.value);
            }
        }
        return rel;
    }
}

