/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.IntegerSerializer;
import com.thinkaurelius.titan.util.encoding.NumericUtils;

public class FloatSerializer
implements OrderPreservingSerializer<Float> {
    private final IntegerSerializer ints = new IntegerSerializer();

    @Override
    public Float convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value too large for float: " + value);
            }
            return Float.valueOf((float)d);
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }

    @Override
    public Float read(ScanBuffer buffer) {
        return Float.valueOf(buffer.getFloat());
    }

    @Override
    public void write(WriteBuffer buffer, Float attribute) {
        buffer.putFloat(attribute.floatValue());
    }

    @Override
    public Float readByteOrder(ScanBuffer buffer) {
        return Float.valueOf(NumericUtils.sortableIntToFloat(this.ints.readByteOrder(buffer)));
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Float attribute) {
        this.ints.writeByteOrder(buffer, NumericUtils.floatToSortableInt(attribute.floatValue()));
    }
}

