/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProviders;
import com.thinkaurelius.titan.graphdb.database.management.AbstractIndexStatusWatcher;
import com.thinkaurelius.titan.graphdb.database.management.GraphIndexStatusReport;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphIndexStatusWatcher
extends AbstractIndexStatusWatcher<GraphIndexStatusReport, GraphIndexStatusWatcher> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphIndexStatusWatcher.class);
    private String graphIndexName;

    public GraphIndexStatusWatcher(TitanGraph g, String graphIndexName) {
        super(g);
        this.graphIndexName = graphIndexName;
    }

    @Override
    protected GraphIndexStatusWatcher self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphIndexStatusReport call() throws InterruptedException {
        Preconditions.checkNotNull((Object)this.g, (Object)"Graph instance must not be null");
        Preconditions.checkNotNull((Object)this.graphIndexName, (Object)"Index name must not be null");
        Preconditions.checkNotNull((Object)((Object)this.status), (Object)"Target status must not be null");
        HashMap<String, SchemaStatus> notConverged = new HashMap<String, SchemaStatus>();
        HashMap<String, SchemaStatus> converged = new HashMap<String, SchemaStatus>();
        Timer t = new Timer(TimestampProviders.MILLI).start();
        while (true) {
            boolean timedOut;
            TitanManagement mgmt = null;
            try {
                mgmt = this.g.openManagement();
                TitanGraphIndex idx = mgmt.getGraphIndex(this.graphIndexName);
                for (PropertyKey pk : idx.getFieldKeys()) {
                    SchemaStatus s = idx.getIndexStatus(pk);
                    LOGGER.debug("Key {} has status {}", (Object)pk, (Object)s);
                    if (!this.status.equals((Object)s)) {
                        notConverged.put(pk.toString(), s);
                        continue;
                    }
                    converged.put(pk.toString(), s);
                }
            }
            finally {
                if (null != mgmt) {
                    mgmt.rollback();
                }
            }
            String waitingOn = Joiner.on((String)",").withKeyValueSeparator("=").join(notConverged);
            if (notConverged.isEmpty()) {
                LOGGER.info("All {} key(s) on index {} have status {}", new Object[]{converged.size(), this.graphIndexName, this.status});
                return new GraphIndexStatusReport(true, this.graphIndexName, this.status, notConverged, converged, t.elapsed());
            }
            LOGGER.info("Some key(s) on index {} do not currently have status {}: {}", new Object[]{this.graphIndexName, this.status, waitingOn});
            boolean bl = timedOut = null != this.timeout && 0 < t.elapsed().compareTo(this.timeout);
            if (timedOut) {
                LOGGER.info("Timed out ({}) while waiting for index {} to converge on status {}", new Object[]{this.timeout, this.graphIndexName, this.status});
                return new GraphIndexStatusReport(false, this.graphIndexName, this.status, notConverged, converged, t.elapsed());
            }
            notConverged.clear();
            converged.clear();
            Thread.sleep(this.poll.toMillis());
        }
    }
}

