/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner.placement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.IDPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionAssignment;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionIDRange;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimplePartitionAssignment;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class SimpleBulkPlacementStrategy
implements IDPlacementStrategy {
    private static final Logger log = LoggerFactory.getLogger(SimpleBulkPlacementStrategy.class);
    public static final ConfigOption<Integer> CONCURRENT_PARTITIONS = new ConfigOption<Integer>(GraphDatabaseConfiguration.IDS_NS, "num-partitions", "Number of partition block to allocate for placement of vertices", ConfigOption.Type.MASKABLE, 10);
    public static final int PARTITION_FINDING_ATTEMPTS = 1000;
    private final Random random = new Random();
    private final int[] currentPartitions;
    private List<PartitionIDRange> localPartitionIdRanges;
    private final Set<Integer> exhaustedPartitions;

    public SimpleBulkPlacementStrategy(int concurrentPartitions) {
        Preconditions.checkArgument((concurrentPartitions > 0 ? 1 : 0) != 0);
        this.currentPartitions = new int[concurrentPartitions];
        this.exhaustedPartitions = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public SimpleBulkPlacementStrategy(Configuration config) {
        this(config.get(CONCURRENT_PARTITIONS, new String[0]));
    }

    private final int nextPartitionID() {
        return this.currentPartitions[this.random.nextInt(this.currentPartitions.length)];
    }

    private final void updateElement(int index) {
        int newPartition;
        Preconditions.checkArgument((this.localPartitionIdRanges != null && !this.localPartitionIdRanges.isEmpty() ? 1 : 0) != 0, (Object)"Local partition id ranges have not been initialized");
        int attempts = 0;
        do {
            newPartition = this.localPartitionIdRanges.get(this.random.nextInt(this.localPartitionIdRanges.size())).getRandomID();
            if (++attempts <= 1000) continue;
            throw new IDPoolExhaustedException("Could not find non-exhausted partition");
        } while (this.exhaustedPartitions.contains(newPartition));
        this.currentPartitions[index] = newPartition;
        log.debug("Setting partition at index [{}] to: {}", (Object)index, (Object)newPartition);
    }

    @Override
    public void injectIDManager(IDManager idManager) {
    }

    @Override
    public int getPartition(InternalElement element) {
        return this.nextPartitionID();
    }

    @Override
    public void getPartitions(Map<InternalVertex, PartitionAssignment> vertices) {
        int partitionID = this.nextPartitionID();
        for (Map.Entry<InternalVertex, PartitionAssignment> entry : vertices.entrySet()) {
            entry.setValue(new SimplePartitionAssignment(partitionID));
        }
    }

    @Override
    public boolean supportsBulkPlacement() {
        return true;
    }

    @Override
    public void setLocalPartitionBounds(List<PartitionIDRange> localPartitionIdRanges) {
        Preconditions.checkArgument((localPartitionIdRanges != null && !localPartitionIdRanges.isEmpty() ? 1 : 0) != 0);
        this.localPartitionIdRanges = Lists.newArrayList(localPartitionIdRanges);
        for (int i = 0; i < this.currentPartitions.length; ++i) {
            this.updateElement(i);
        }
    }

    public boolean isExhaustedPartition(int partitionID) {
        return this.exhaustedPartitions.contains(partitionID);
    }

    @Override
    public void exhaustedPartition(int partitionID) {
        this.exhaustedPartitions.add(partitionID);
        boolean found = false;
        for (int i = 0; i < this.currentPartitions.length; ++i) {
            if (this.currentPartitions[i] != partitionID) continue;
            this.updateElement(i);
            found = true;
        }
    }
}

