/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.example;

import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import java.io.File;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraphOfTheGodsFactory {
    public static final String INDEX_NAME = "search";

    public static TitanGraph create(String directory) {
        TitanFactory.Builder config = TitanFactory.build();
        config.set("storage.backend", "berkeleyje");
        config.set("storage.directory", directory);
        config.set("index.search.backend", "elasticsearch");
        config.set("index.search.directory", directory + File.separator + "es");
        config.set("index.search.elasticsearch.local-mode", true);
        config.set("index.search.elasticsearch.client-only", false);
        TitanGraph graph = config.open();
        GraphOfTheGodsFactory.load(graph);
        return graph;
    }

    public static void loadWithoutMixedIndex(TitanGraph graph, boolean uniqueNameCompositeIndex) {
        GraphOfTheGodsFactory.load(graph, null, uniqueNameCompositeIndex);
    }

    public static void load(TitanGraph graph) {
        GraphOfTheGodsFactory.load(graph, INDEX_NAME, true);
    }

    public static void load(TitanGraph graph, String mixedIndexName, boolean uniqueNameCompositeIndex) {
        TitanManagement mgmt = graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).make();
        TitanManagement.IndexBuilder nameIndexBuilder = mgmt.buildIndex("name", Vertex.class).addKey(name);
        if (uniqueNameCompositeIndex) {
            nameIndexBuilder.unique();
        }
        TitanGraphIndex namei = nameIndexBuilder.buildCompositeIndex();
        mgmt.setConsistency(namei, ConsistencyModifier.LOCK);
        PropertyKey age = mgmt.makePropertyKey("age").dataType(Integer.class).make();
        if (null != mixedIndexName) {
            mgmt.buildIndex("vertices", Vertex.class).addKey(age).buildMixedIndex(mixedIndexName);
        }
        PropertyKey time = mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey reason = mgmt.makePropertyKey("reason").dataType(String.class).make();
        PropertyKey place = mgmt.makePropertyKey("place").dataType(Geoshape.class).make();
        if (null != mixedIndexName) {
            mgmt.buildIndex("edges", Edge.class).addKey(reason).addKey(place).buildMixedIndex(mixedIndexName);
        }
        mgmt.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        mgmt.makeEdgeLabel("mother").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel battled = mgmt.makeEdgeLabel("battled").signature(time).make();
        mgmt.buildEdgeIndex(battled, "battlesByTime", Direction.BOTH, Order.decr, time);
        mgmt.makeEdgeLabel("lives").signature(reason).make();
        mgmt.makeEdgeLabel("pet").make();
        mgmt.makeEdgeLabel("brother").make();
        mgmt.makeVertexLabel("titan").make();
        mgmt.makeVertexLabel("location").make();
        mgmt.makeVertexLabel("god").make();
        mgmt.makeVertexLabel("demigod").make();
        mgmt.makeVertexLabel("human").make();
        mgmt.makeVertexLabel("monster").make();
        mgmt.commit();
        TitanTransaction tx = graph.newTransaction();
        TitanVertex saturn = tx.addVertex(T.label, "titan", "name", "saturn", "age", 10000);
        TitanVertex sky = tx.addVertex(T.label, "location", "name", "sky");
        TitanVertex sea = tx.addVertex(T.label, "location", "name", "sea");
        TitanVertex jupiter = tx.addVertex(T.label, "god", "name", "jupiter", "age", 5000);
        TitanVertex neptune = tx.addVertex(T.label, "god", "name", "neptune", "age", 4500);
        TitanVertex hercules = tx.addVertex(T.label, "demigod", "name", "hercules", "age", 30);
        TitanVertex alcmene = tx.addVertex(T.label, "human", "name", "alcmene", "age", 45);
        TitanVertex pluto = tx.addVertex(T.label, "god", "name", "pluto", "age", 4000);
        TitanVertex nemean = tx.addVertex(T.label, "monster", "name", "nemean");
        TitanVertex hydra = tx.addVertex(T.label, "monster", "name", "hydra");
        TitanVertex cerberus = tx.addVertex(T.label, "monster", "name", "cerberus");
        TitanVertex tartarus = tx.addVertex(T.label, "location", "name", "tartarus");
        jupiter.addEdge("father", saturn, new Object[0]);
        jupiter.addEdge("lives", sky, new Object[]{"reason", "loves fresh breezes"});
        jupiter.addEdge("brother", neptune, new Object[0]);
        jupiter.addEdge("brother", pluto, new Object[0]);
        neptune.addEdge("lives", sea, new Object[0]).property("reason", (Object)"loves waves");
        neptune.addEdge("brother", jupiter, new Object[0]);
        neptune.addEdge("brother", pluto, new Object[0]);
        hercules.addEdge("father", jupiter, new Object[0]);
        hercules.addEdge("mother", alcmene, new Object[0]);
        hercules.addEdge("battled", nemean, new Object[]{"time", 1, "place", Geoshape.point(38.1f, 23.7f)});
        hercules.addEdge("battled", hydra, new Object[]{"time", 2, "place", Geoshape.point(37.7f, 23.9f)});
        hercules.addEdge("battled", cerberus, new Object[]{"time", 12, "place", Geoshape.point(39.0, 22.0)});
        pluto.addEdge("brother", jupiter, new Object[0]);
        pluto.addEdge("brother", neptune, new Object[0]);
        pluto.addEdge("lives", tartarus, new Object[]{"reason", "no fear of death"});
        pluto.addEdge("pet", cerberus, new Object[0]);
        cerberus.addEdge("lives", tartarus, new Object[0]);
        tx.commit();
    }

    public static void main(String[] args) {
        if (null == args || 1 != args.length) {
            System.err.println("Usage: GraphOfTheGodsFactory <titan-config-file>");
            System.exit(1);
        }
        TitanGraph g = TitanFactory.open(args[0]);
        GraphOfTheGodsFactory.load(g);
        g.close();
    }
}

