/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.time.Instant;

public class ReadMarker {
    private final String identifier;
    private Instant startTime;

    private ReadMarker(String identifier, Instant startTime) {
        this.identifier = identifier;
        this.startTime = startTime;
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String getIdentifier() {
        Preconditions.checkArgument((this.identifier != null ? 1 : 0) != 0, (Object)"ReadMarker does not have a configured identifier");
        return this.identifier;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public synchronized Instant getStartTime(TimestampProvider times) {
        if (this.startTime == null) {
            this.startTime = times.getTime();
        }
        return this.startTime;
    }

    public boolean isCompatible(ReadMarker newMarker) {
        if (newMarker.hasIdentifier()) {
            return this.hasIdentifier() && this.identifier.equals(newMarker.identifier);
        }
        return !newMarker.hasStartTime();
    }

    public static ReadMarker fromNow() {
        return new ReadMarker(null, null);
    }

    public static ReadMarker fromTime(Instant timestamp) {
        return new ReadMarker(null, timestamp);
    }

    public static ReadMarker fromIdentifierOrTime(String id, Instant timestamp) {
        return new ReadMarker(id, timestamp);
    }

    public static ReadMarker fromIdentifierOrNow(String id) {
        return new ReadMarker(id, Instant.EPOCH);
    }
}

