/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan;

import com.thinkaurelius.titan.diskstorage.keycolumnvalue.scan.ScanMetrics;
import java.util.EnumMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardScanMetrics
implements ScanMetrics {
    private final EnumMap<ScanMetrics.Metric, AtomicLong> metrics = new EnumMap(ScanMetrics.Metric.class);
    private final ConcurrentMap<String, AtomicLong> customMetrics;
    private static final Logger log = LoggerFactory.getLogger(StandardScanMetrics.class);

    public StandardScanMetrics() {
        for (ScanMetrics.Metric m : ScanMetrics.Metric.values()) {
            this.metrics.put(m, new AtomicLong(0L));
        }
        this.customMetrics = new ConcurrentHashMap<String, AtomicLong>();
    }

    @Override
    public long getCustom(String metric) {
        AtomicLong counter = (AtomicLong)this.customMetrics.get(metric);
        if (counter == null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}:{}] Returning zero by default (was null)", (Object)System.identityHashCode(this.customMetrics), (Object)metric);
            }
            return 0L;
        }
        long v = counter.get();
        if (log.isDebugEnabled()) {
            log.debug("[{}:{}] Returning {}", new Object[]{System.identityHashCode(this.customMetrics), metric, v});
        }
        return v;
    }

    @Override
    public void incrementCustom(String metric, long delta) {
        AtomicLong counter = (AtomicLong)this.customMetrics.get(metric);
        if (counter == null) {
            this.customMetrics.putIfAbsent(metric, new AtomicLong(0L));
            counter = (AtomicLong)this.customMetrics.get(metric);
        }
        counter.addAndGet(delta);
        if (log.isDebugEnabled()) {
            log.debug("[{}:{}] Incremented by {}", new Object[]{System.identityHashCode(this.customMetrics), metric, delta});
        }
    }

    @Override
    public void incrementCustom(String metric) {
        this.incrementCustom(metric, 1L);
    }

    @Override
    public long get(ScanMetrics.Metric metric) {
        return this.metrics.get((Object)metric).get();
    }

    @Override
    public void increment(ScanMetrics.Metric metric) {
        this.metrics.get((Object)metric).incrementAndGet();
    }
}

