/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class KeySliceQuery
extends SliceQuery {
    private final StaticBuffer key;

    public KeySliceQuery(StaticBuffer key, StaticBuffer sliceStart, StaticBuffer sliceEnd) {
        super(sliceStart, sliceEnd);
        Preconditions.checkNotNull((Object)key);
        this.key = key;
    }

    public KeySliceQuery(StaticBuffer key, SliceQuery query) {
        super(query);
        Preconditions.checkNotNull((Object)key);
        this.key = key;
    }

    public StaticBuffer getKey() {
        return this.key;
    }

    @Override
    public KeySliceQuery setLimit(int limit) {
        super.setLimit(limit);
        return this;
    }

    @Override
    public KeySliceQuery updateLimit(int newLimit) {
        return new KeySliceQuery(this.key, this).setLimit(newLimit);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        KeySliceQuery oth = (KeySliceQuery)other;
        return this.key.equals(oth.key) && super.equals(oth);
    }

    public boolean subsumes(KeySliceQuery oth) {
        return this.key.equals(oth.key) && super.subsumes(oth);
    }

    public String toString() {
        return String.format("KeySliceQuery(key: %s, start: %s, end: %s, limit:%d)", this.key, this.getSliceStart(), this.getSliceEnd(), this.getLimit());
    }
}

