/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;

public class StandardKeyInformation
implements KeyInformation {
    private final Class<?> dataType;
    private final Parameter[] parameters;
    private final Cardinality cardinality;

    public StandardKeyInformation(Class<?> dataType, Cardinality cardinality, Parameter ... parameters) {
        Preconditions.checkNotNull(dataType);
        Preconditions.checkNotNull((Object)parameters);
        this.dataType = dataType;
        this.parameters = parameters;
        this.cardinality = cardinality;
    }

    public StandardKeyInformation(PropertyKey key, Parameter ... parameters) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)parameters);
        this.dataType = key.dataType();
        this.parameters = parameters;
        this.cardinality = key.cardinality();
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean hasParameters() {
        return this.parameters.length > 0;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }
}

