/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.idmanagement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDBlockSizer;
import java.time.Duration;

public abstract class AbstractIDAuthority
implements IDAuthority {
    protected static final long BASE_ID = 1L;
    protected final Duration idApplicationWaitMS;
    protected final String uid;
    protected final byte[] uidBytes;
    protected final String metricsPrefix;
    private IDBlockSizer blockSizer;
    private volatile boolean isActive;

    public AbstractIDAuthority(Configuration config) {
        this.uid = config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]);
        this.uidBytes = this.uid.getBytes();
        this.isActive = false;
        this.idApplicationWaitMS = config.get(GraphDatabaseConfiguration.IDAUTHORITY_WAIT, new String[0]);
        this.metricsPrefix = GraphDatabaseConfiguration.getSystemMetricsPrefix();
    }

    @Override
    public synchronized void setIDBlockSizer(IDBlockSizer sizer) {
        Preconditions.checkNotNull((Object)sizer);
        if (this.isActive) {
            throw new IllegalStateException("IDBlockSizer cannot be changed after IDAuthority is in use");
        }
        this.blockSizer = sizer;
    }

    @Override
    public String getUniqueID() {
        return this.uid;
    }

    protected StaticBuffer getPartitionKey(int partition) {
        return BufferUtil.getIntBuffer(partition);
    }

    protected long getBlockSize(int idNamespace) {
        Preconditions.checkArgument((this.blockSizer != null ? 1 : 0) != 0, (Object)"Blocksizer has not yet been initialized");
        this.isActive = true;
        long blockSize = this.blockSizer.getBlockSize(idNamespace);
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"Invalid block size: %s", (Object[])new Object[]{blockSize});
        Preconditions.checkArgument((blockSize < this.getIdUpperBound(idNamespace) ? 1 : 0) != 0, (String)"Block size [%s] cannot be larger than upper bound [%s] for partition [%s]", (Object[])new Object[]{blockSize, this.getIdUpperBound(idNamespace), idNamespace});
        return blockSize;
    }

    protected long getIdUpperBound(int idNamespace) {
        Preconditions.checkArgument((this.blockSizer != null ? 1 : 0) != 0, (Object)"Blocksizer has not yet been initialized");
        this.isActive = true;
        long upperBound = this.blockSizer.getIdUpperBound(idNamespace);
        Preconditions.checkArgument((upperBound > 0L ? 1 : 0) != 0, (String)"Invalid upper bound: %s", (Object[])new Object[]{upperBound});
        return upperBound;
    }
}

