/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import java.util.Map;
import java.util.Set;

public class MergedConfiguration
implements Configuration {
    private final Configuration first;
    private final Configuration second;

    public MergedConfiguration(Configuration first, Configuration second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean has(ConfigOption option, String ... umbrellaElements) {
        return this.first.has(option, umbrellaElements) || this.second.has(option, umbrellaElements);
    }

    @Override
    public <O> O get(ConfigOption<O> option, String ... umbrellaElements) {
        if (this.first.has(option, umbrellaElements)) {
            return this.first.get(option, umbrellaElements);
        }
        if (this.second.has(option, umbrellaElements)) {
            return this.second.get(option, umbrellaElements);
        }
        return option.getDefaultValue();
    }

    @Override
    public Set<String> getContainedNamespaces(ConfigNamespace umbrella, String ... umbrellaElements) {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll(this.first.getContainedNamespaces(umbrella, umbrellaElements));
        b.addAll(this.second.getContainedNamespaces(umbrella, umbrellaElements));
        return b.build();
    }

    @Override
    public Map<String, Object> getSubset(ConfigNamespace umbrella, String ... umbrellaElements) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        Map<String, Object> fm = this.first.getSubset(umbrella, umbrellaElements);
        Map<String, Object> sm = this.second.getSubset(umbrella, umbrellaElements);
        b.putAll(this.first.getSubset(umbrella, umbrellaElements));
        for (Map.Entry<String, Object> secondEntry : sm.entrySet()) {
            if (fm.containsKey(secondEntry.getKey())) continue;
            b.put(secondEntry);
        }
        return b.build();
    }

    @Override
    public Configuration restrictTo(String ... umbrellaElements) {
        return new MergedConfiguration(this.first.restrictTo(umbrellaElements), this.second.restrictTo(umbrellaElements));
    }
}

