/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import java.time.Duration;
import java.util.concurrent.Callable;

public class TitanCleanup {
    public static final void clear(TitanGraph graph) {
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)(graph instanceof StandardTitanGraph), (String)"Invalid graph instance detected: %s", (Object[])new Object[]{graph.getClass()});
        StandardTitanGraph g = (StandardTitanGraph)graph;
        Preconditions.checkArgument((!g.isOpen() ? 1 : 0) != 0, (Object)"Graph needs to be shut down before it can be cleared.");
        final GraphDatabaseConfiguration config = g.getConfiguration();
        BackendOperation.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                config.getBackend().clearStorage();
                return true;
            }

            public String toString() {
                return "ClearBackend";
            }
        }, Duration.ofSeconds(20L));
    }
}

