/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import org.apache.commons.lang3.StringUtils;

public class ManagementUtil {
    public static void awaitGraphIndexUpdate(TitanGraph g, String indexName, long time, TemporalUnit unit) {
        ManagementUtil.awaitIndexUpdate(g, indexName, null, time, unit);
    }

    public static void awaitVertexIndexUpdate(TitanGraph g, String indexName, String relationTypeName, long time, TemporalUnit unit) {
        ManagementUtil.awaitIndexUpdate(g, indexName, relationTypeName, time, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void awaitIndexUpdate(TitanGraph g, String indexName, String relationTypeName, long time, TemporalUnit unit) {
        Preconditions.checkArgument((g != null && g.isOpen() ? 1 : 0) != 0, (Object)"Need to provide valid, open graph instance");
        Preconditions.checkArgument((time > 0L && unit != null ? 1 : 0) != 0, (Object)"Need to provide valid time interval");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)indexName), (Object)"Need to provide an index name");
        StandardTitanGraph graph = (StandardTitanGraph)g;
        TimestampProvider times = graph.getConfiguration().getTimestampProvider();
        Instant end = times.getTime().plus(Duration.of(time, unit));
        boolean isStable = false;
        while (times.getTime().isBefore(end)) {
            TitanManagement mgmt = graph.openManagement();
            try {
                TitanIndex idx;
                if (StringUtils.isNotBlank((CharSequence)relationTypeName)) {
                    idx = mgmt.getRelationIndex(mgmt.getRelationType(relationTypeName), indexName);
                    Preconditions.checkArgument((idx != null ? 1 : 0) != 0, (String)"Index could not be found: %s @ %s", (Object[])new Object[]{indexName, relationTypeName});
                    isStable = idx.getIndexStatus().isStable();
                } else {
                    idx = mgmt.getGraphIndex(indexName);
                    Preconditions.checkArgument((idx != null ? 1 : 0) != 0, (String)"Index could not be found: %s", (Object[])new Object[]{indexName});
                    isStable = true;
                    for (PropertyKey key : idx.getFieldKeys()) {
                        if (idx.getIndexStatus(key).isStable()) continue;
                        isStable = false;
                    }
                }
            }
            finally {
                mgmt.rollback();
            }
            if (isStable) break;
            try {
                times.sleepFor(Duration.ofMillis(500L));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!isStable) {
            throw new TitanException("Index did not stabilize within the given amount of time. For sufficiently long wait periods this is most likely caused by a failed/incorrectly shut down Titan instance or a lingering transaction.");
        }
    }
}

