/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.schema;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.graphdb.types.ParameterType;

public enum Mapping {
    DEFAULT,
    TEXT,
    STRING,
    TEXTSTRING,
    PREFIX_TREE;


    public Parameter asParameter() {
        return ParameterType.MAPPING.getParameter(this);
    }

    public static Mapping getMapping(KeyInformation information) {
        Object value = ParameterType.MAPPING.findParameter(information.getParameters(), null);
        if (value == null) {
            return DEFAULT;
        }
        Preconditions.checkArgument((value instanceof Mapping || value instanceof String ? 1 : 0) != 0, (String)"Invalid mapping specified: %s", (Object[])new Object[]{value});
        if (value instanceof String) {
            value = Mapping.valueOf(value.toString().toUpperCase());
        }
        return (Mapping)((Object)value);
    }

    public static Mapping getMapping(String store, String key, KeyInformation.IndexRetriever informations) {
        KeyInformation ki = informations.get(store, key);
        Preconditions.checkArgument((ki != null ? 1 : 0) != 0, (String)"Could not find key information for: %s", (Object[])new Object[]{key});
        return Mapping.getMapping(ki);
    }
}

