/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;

public enum Geo implements TitanPredicate
{
    INTERSECT{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).intersect((Geoshape)condition);
        }

        public String toString() {
            return "intersect";
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public TitanPredicate negate() {
            return DISJOINT;
        }
    }
    ,
    DISJOINT{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).disjoint((Geoshape)condition);
        }

        public String toString() {
            return "disjoint";
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public TitanPredicate negate() {
            return INTERSECT;
        }
    }
    ,
    WITHIN{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).within((Geoshape)condition);
        }

        public String toString() {
            return "within";
        }

        @Override
        public boolean hasNegation() {
            return false;
        }

        @Override
        public TitanPredicate negate() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CONTAINS{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).contains((Geoshape)condition);
        }

        public String toString() {
            return "contains";
        }

        @Override
        public boolean hasNegation() {
            return false;
        }

        @Override
        public TitanPredicate negate() {
            throw new UnsupportedOperationException();
        }
    };


    @Override
    public boolean isValidCondition(Object condition) {
        return condition != null && condition instanceof Geoshape;
    }

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return clazz.equals(Geoshape.class);
    }

    @Override
    public boolean isQNF() {
        return true;
    }

    public static <V> P<V> geoIntersect(V value) {
        return new P((BiPredicate)INTERSECT, value);
    }

    public static <V> P<V> geoDisjoint(V value) {
        return new P((BiPredicate)DISJOINT, value);
    }

    public static <V> P<V> geoWithin(V value) {
        return new P((BiPredicate)WITHIN, value);
    }

    public static <V> P<V> geoContains(V value) {
        return new P((BiPredicate)CONTAINS, value);
    }
}

