/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.log.LogProcessorFramework;
import com.thinkaurelius.titan.core.log.TransactionRecovery;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.StandardStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.CommonsConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.log.StandardLogProcessorFramework;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionLogProcessor;
import java.io.File;
import java.time.Instant;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanFactory {
    private static final Logger log = LoggerFactory.getLogger(TitanFactory.class);

    public static TitanGraph open(String shortcutOrFile) {
        return TitanFactory.open(TitanFactory.getLocalConfiguration(shortcutOrFile));
    }

    public static TitanGraph open(Configuration configuration) {
        return TitanFactory.open(new CommonsConfiguration(configuration));
    }

    public static TitanGraph open(BasicConfiguration configuration) {
        return TitanFactory.open(configuration.getConfiguration());
    }

    public static TitanGraph open(ReadConfiguration configuration) {
        return new StandardTitanGraph(new GraphDatabaseConfiguration(configuration));
    }

    public static Builder build() {
        return new Builder();
    }

    public static LogProcessorFramework openTransactionLog(TitanGraph graph) {
        return new StandardLogProcessorFramework((StandardTitanGraph)graph);
    }

    public static TransactionRecovery startTransactionRecovery(TitanGraph graph, Instant start) {
        return new StandardTransactionLogProcessor((StandardTitanGraph)graph, start);
    }

    private static ReadConfiguration getLocalConfiguration(String shortcutOrFile) {
        File file = new File(shortcutOrFile);
        if (file.exists()) {
            return TitanFactory.getLocalConfiguration(file);
        }
        int pos = shortcutOrFile.indexOf(58);
        if (pos < 0) {
            pos = shortcutOrFile.length();
        }
        String backend = shortcutOrFile.substring(0, pos);
        Preconditions.checkArgument((boolean)StandardStoreManager.getAllManagerClasses().containsKey(backend.toLowerCase()), (String)"Backend shorthand unknown: %s", (Object[])new Object[]{backend});
        String secondArg = null;
        if (pos + 1 < shortcutOrFile.length()) {
            secondArg = shortcutOrFile.substring(pos + 1).trim();
        }
        BaseConfiguration config = new BaseConfiguration();
        ModifiableConfiguration writeConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, new CommonsConfiguration((Configuration)config), BasicConfiguration.Restriction.NONE);
        writeConfig.set(GraphDatabaseConfiguration.STORAGE_BACKEND, backend, new String[0]);
        ConfigOption<?> option = Backend.getOptionForShorthand(backend);
        if (option == null) {
            Preconditions.checkArgument((secondArg == null ? 1 : 0) != 0);
        } else if (option == GraphDatabaseConfiguration.STORAGE_DIRECTORY || option == GraphDatabaseConfiguration.STORAGE_CONF_FILE) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)secondArg), (Object)"Need to provide additional argument to initialize storage backend");
            writeConfig.set(option, TitanFactory.getAbsolutePath(secondArg), new String[0]);
        } else if (option == GraphDatabaseConfiguration.STORAGE_HOSTS) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)secondArg), (Object)"Need to provide additional argument to initialize storage backend");
            writeConfig.set(option, new String[]{secondArg}, new String[0]);
        } else {
            throw new IllegalArgumentException("Invalid configuration option for backend " + option);
        }
        return new CommonsConfiguration((Configuration)config);
    }

    private static ReadConfiguration getLocalConfiguration(File file) {
        Preconditions.checkArgument((file != null && file.exists() && file.isFile() && file.canRead() ? 1 : 0) != 0, (String)"Need to specify a readable configuration file, but was given: %s", (Object[])new Object[]{file.toString()});
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration(file);
            File tmpParent = file.getParentFile();
            File configParent = null == tmpParent ? new File(System.getProperty("user.dir")) : tmpParent;
            Preconditions.checkNotNull((Object)configParent);
            Preconditions.checkArgument((boolean)configParent.isDirectory());
            final Pattern p = Pattern.compile("(" + Pattern.quote(GraphDatabaseConfiguration.STORAGE_NS.getName()) + "\\..*(" + Pattern.quote(GraphDatabaseConfiguration.STORAGE_DIRECTORY.getName()) + "|" + Pattern.quote(GraphDatabaseConfiguration.STORAGE_CONF_FILE.getName()) + ")|" + Pattern.quote(GraphDatabaseConfiguration.INDEX_NS.getName()) + "\\..*(" + Pattern.quote(GraphDatabaseConfiguration.INDEX_DIRECTORY.getName()) + "|" + Pattern.quote(GraphDatabaseConfiguration.INDEX_CONF_FILE.getName()) + "))");
            UnmodifiableIterator keysToMangle = Iterators.filter((Iterator)configuration.getKeys(), (Predicate)new Predicate<String>(){

                public boolean apply(String key) {
                    if (null == key) {
                        return false;
                    }
                    return p.matcher(key).matches();
                }
            });
            while (keysToMangle.hasNext()) {
                String k = (String)keysToMangle.next();
                Preconditions.checkNotNull((Object)k);
                String s = configuration.getString(k);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)s), (String)"Invalid Configuration: key %s has null empty value", (Object[])new Object[]{k});
                configuration.setProperty(k, (Object)TitanFactory.getAbsolutePath(configParent, s));
            }
            return new CommonsConfiguration((Configuration)configuration);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Could not load configuration at: " + file, e);
        }
    }

    private static final String getAbsolutePath(String file) {
        return TitanFactory.getAbsolutePath(new File(System.getProperty("user.dir")), file);
    }

    private static final String getAbsolutePath(File configParent, String file) {
        File storedir = new File(file);
        if (!storedir.isAbsolute()) {
            String newFile = configParent.getAbsolutePath() + File.separator + file;
            log.debug("Overwrote relative path: was {}, now {}", (Object)file, (Object)newFile);
            return newFile;
        }
        log.debug("Loaded absolute path for key: {}", (Object)file);
        return file;
    }

    public static class Builder {
        private final WriteConfiguration writeConfiguration = new CommonsConfiguration();

        private Builder() {
        }

        public Builder set(String path, Object value) {
            this.writeConfiguration.set(path, value);
            return this;
        }

        public TitanGraph open() {
            ModifiableConfiguration mc = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.writeConfiguration.copy(), BasicConfiguration.Restriction.NONE);
            return TitanFactory.open(mc);
        }
    }
}

