/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.optimize;

import com.thinkaurelius.titan.graphdb.tinkerpop.ElementUtils;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.HasStepFolder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanGraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class TitanGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final TitanGraphStepStrategy INSTANCE = new TitanGraphStepStrategy();

    private TitanGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        TraversalHelper.getStepsOfClass(GraphStep.class, traversal).forEach(originalGraphStep -> {
            if (originalGraphStep.getIds() == null || originalGraphStep.getIds().length == 0) {
                TitanGraphStep titanGraphStep = new TitanGraphStep(originalGraphStep);
                TraversalHelper.replaceStep((Step)originalGraphStep, titanGraphStep, (Traversal.Admin)traversal);
                HasStepFolder.foldInHasContainer(titanGraphStep, traversal);
                HasStepFolder.foldInOrder(titanGraphStep, traversal, traversal, titanGraphStep.returnsVertex());
                HasStepFolder.foldInRange(titanGraphStep, traversal);
            } else {
                Object[] ids = originalGraphStep.getIds();
                ElementUtils.verifyArgsMustBeEitherIdorElement(ids);
                if (ids[0] instanceof Element) {
                    Object[] elementIds = new Object[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        elementIds[i] = ((Element)ids[i]).id();
                    }
                    originalGraphStep.setIteratorSupplier(() -> originalGraphStep.returnsVertex() ? ((Graph)originalGraphStep.getTraversal().getGraph().get()).vertices(elementIds) : ((Graph)originalGraphStep.getTraversal().getGraph().get()).edges(elementIds));
                }
            }
        });
    }

    public static TitanGraphStepStrategy instance() {
        return INSTANCE;
    }
}

