/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop;

import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanFeatures
implements Graph.Features {
    private static final Logger log = LoggerFactory.getLogger(TitanFeatures.class);
    private final Graph.Features.GraphFeatures graphFeatures;
    private final Graph.Features.VertexFeatures vertexFeatures;
    private final Graph.Features.EdgeFeatures edgeFeatures;
    private final StandardTitanGraph graph;

    private TitanFeatures(StandardTitanGraph graph, StoreFeatures storageFeatures) {
        this.graphFeatures = new TitanGraphFeatures(storageFeatures.supportsPersistence());
        this.vertexFeatures = new TitanVertexFeatures();
        this.edgeFeatures = new TitanEdgeFeatures();
        this.graph = graph;
    }

    public Graph.Features.GraphFeatures graph() {
        return this.graphFeatures;
    }

    public Graph.Features.VertexFeatures vertex() {
        return this.vertexFeatures;
    }

    public Graph.Features.EdgeFeatures edge() {
        return this.edgeFeatures;
    }

    public String toString() {
        return StringFactory.featureString((Graph.Features)this);
    }

    public static TitanFeatures getFeatures(StandardTitanGraph graph, StoreFeatures storageFeatures) {
        return new TitanFeatures(graph, storageFeatures);
    }

    private static class TitanEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        private TitanEdgeFeatures() {
        }

        public Graph.Features.EdgePropertyFeatures properties() {
            return new TitanEdgePropertyFeatures();
        }

        public boolean supportsCustomIds() {
            return true;
        }

        public boolean supportsUserSuppliedIds() {
            return false;
        }

        public boolean supportsNumericIds() {
            return false;
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }

        public boolean supportsStringIds() {
            return false;
        }
    }

    private class TitanVertexFeatures
    implements Graph.Features.VertexFeatures {
        private TitanVertexFeatures() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VertexProperty.Cardinality getCardinality(String key) {
            StandardTitanTx tx = (StandardTitanTx)TitanFeatures.this.graph.newTransaction();
            try {
                if (!tx.containsPropertyKey(key)) {
                    VertexProperty.Cardinality cardinality = tx.getConfiguration().getAutoSchemaMaker().defaultPropertyCardinality(key).convert();
                    return cardinality;
                }
                VertexProperty.Cardinality cardinality = tx.getPropertyKey(key).cardinality().convert();
                return cardinality;
            }
            finally {
                tx.rollback();
            }
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return new TitanVertexPropertyFeatures();
        }

        public boolean supportsNumericIds() {
            return true;
        }

        public boolean supportsUserSuppliedIds() {
            return TitanFeatures.this.graph.getConfiguration().allowVertexIdSetting();
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }

        public boolean supportsStringIds() {
            return false;
        }

        public boolean supportsCustomIds() {
            return false;
        }
    }

    private static class TitanEdgePropertyFeatures
    extends TitanDataTypeFeatures
    implements Graph.Features.EdgePropertyFeatures {
        private TitanEdgePropertyFeatures() {
        }
    }

    private static class TitanVertexPropertyFeatures
    extends TitanDataTypeFeatures
    implements Graph.Features.VertexPropertyFeatures {
        private TitanVertexPropertyFeatures() {
        }

        public boolean supportsUserSuppliedIds() {
            return false;
        }

        public boolean supportsNumericIds() {
            return false;
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }
    }

    private static class TitanGraphFeatures
    extends TitanDataTypeFeatures
    implements Graph.Features.GraphFeatures {
        private final boolean persists;

        private TitanGraphFeatures(boolean persists) {
            this.persists = persists;
        }

        public Graph.Features.VariableFeatures variables() {
            return new TitanVariableFeatures();
        }

        public boolean supportsComputer() {
            return true;
        }

        public boolean supportsPersistence() {
            return this.persists;
        }

        public boolean supportsTransactions() {
            return true;
        }

        public boolean supportsThreadedTransactions() {
            return true;
        }
    }

    private static class TitanVariableFeatures
    extends TitanDataTypeFeatures
    implements Graph.Features.VariableFeatures {
        private TitanVariableFeatures() {
        }
    }

    private static class TitanDataTypeFeatures
    implements Graph.Features.DataTypeFeatures {
        private TitanDataTypeFeatures() {
        }

        public boolean supportsMapValues() {
            return false;
        }

        public boolean supportsMixedListValues() {
            return false;
        }

        public boolean supportsSerializableValues() {
            return false;
        }

        public boolean supportsUniformListValues() {
            return false;
        }
    }
}

