/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.thinkaurelius.titan.diskstorage.util.time.Temporals;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TimestampProviders implements TimestampProvider
{
    NANO{

        @Override
        public Instant getTime() {
            return Instant.now();
        }

        @Override
        public Instant getTime(long sinceEpoch) {
            return Instant.ofEpochSecond(0L, sinceEpoch);
        }

        @Override
        public ChronoUnit getUnit() {
            return ChronoUnit.NANOS;
        }

        @Override
        public long getTime(Instant timestamp) {
            return timestamp.getEpochSecond() * 1000000000L + (long)timestamp.getNano();
        }
    }
    ,
    MICRO{

        @Override
        public Instant getTime() {
            return Instant.now();
        }

        @Override
        public Instant getTime(long sinceEpoch) {
            return Instant.ofEpochSecond(0L, sinceEpoch * 1000L);
        }

        @Override
        public ChronoUnit getUnit() {
            return ChronoUnit.MICROS;
        }

        @Override
        public long getTime(Instant timestamp) {
            return timestamp.getEpochSecond() * 1000000L + (long)(timestamp.getNano() / 1000);
        }
    }
    ,
    MILLI{

        @Override
        public Instant getTime() {
            return Instant.now();
        }

        @Override
        public Instant getTime(long sinceEpoch) {
            return Instant.ofEpochMilli(sinceEpoch);
        }

        @Override
        public ChronoUnit getUnit() {
            return ChronoUnit.MILLIS;
        }

        @Override
        public long getTime(Instant timestamp) {
            return timestamp.getEpochSecond() * 1000L + (long)(timestamp.getNano() / 1000000);
        }
    };

    private static final Logger log;

    @Override
    public Instant sleepPast(Instant futureTime) throws InterruptedException {
        Instant now;
        ChronoUnit unit = this.getUnit();
        if (unit.equals((Object)TimeUnit.MILLISECONDS)) {
            futureTime = futureTime.plusMillis(1L);
        }
        while ((now = this.getTime()).compareTo(futureTime) <= 0) {
            long delta = this.getTime(futureTime) - this.getTime(now);
            if (0L == delta) {
                delta = 1L;
            }
            if (log.isTraceEnabled()) {
                log.trace("Sleeping: now={} targettime={} delta={} {}", new Object[]{now, futureTime, delta, unit});
            }
            Temporals.timeUnit(unit).sleep(delta);
        }
        return now;
    }

    @Override
    public void sleepFor(Duration duration) throws InterruptedException {
        if (duration.isZero()) {
            return;
        }
        TimeUnit.NANOSECONDS.sleep(duration.toNanos());
    }

    @Override
    public Timer getTimer() {
        return new Timer(this);
    }

    public String toString() {
        return this.name();
    }

    static {
        log = LoggerFactory.getLogger(TimestampProviders.class);
    }
}

