/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory.ColumnValueStore;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class InMemoryKeyColumnValueStore
implements KeyColumnValueStore {
    private final String name;
    private final ConcurrentNavigableMap<StaticBuffer, ColumnValueStore> kcv;

    public InMemoryKeyColumnValueStore(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        this.name = name;
        this.kcv = new ConcurrentSkipListMap<StaticBuffer, ColumnValueStore>();
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        ColumnValueStore cvs = (ColumnValueStore)this.kcv.get(query.getKey());
        if (cvs == null) {
            return EntryList.EMPTY_LIST;
        }
        return cvs.getSlice(query, txh);
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        HashMap result = Maps.newHashMap();
        for (StaticBuffer key : keys) {
            result.put(key, this.getSlice(new KeySliceQuery(key, query), txh));
        }
        return result;
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        ColumnValueStore cvs = (ColumnValueStore)this.kcv.get(key);
        if (cvs == null) {
            this.kcv.putIfAbsent(key, new ColumnValueStore());
            cvs = (ColumnValueStore)this.kcv.get(key);
        }
        cvs.mutate(additions, deletions, txh);
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
        return new RowIterator(this.kcv.subMap((Object)query.getKeyStart(), (Object)query.getKeyEnd()).entrySet().iterator(), query, txh);
    }

    @Override
    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        return new RowIterator(this.kcv.entrySet().iterator(), query, txh);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void clear() {
        this.kcv.clear();
    }

    @Override
    public void close() throws BackendException {
        this.kcv.clear();
    }

    private static class RowIterator
    implements KeyIterator {
        private final Iterator<Map.Entry<StaticBuffer, ColumnValueStore>> rows;
        private final SliceQuery columnSlice;
        private final StoreTransaction transaction;
        private Map.Entry<StaticBuffer, ColumnValueStore> currentRow;
        private Map.Entry<StaticBuffer, ColumnValueStore> nextRow;
        private boolean isClosed;

        public RowIterator(Iterator<Map.Entry<StaticBuffer, ColumnValueStore>> rows, @Nullable SliceQuery columns, final StoreTransaction transaction) {
            this.rows = Iterators.filter(rows, (Predicate)new Predicate<Map.Entry<StaticBuffer, ColumnValueStore>>(){

                public boolean apply(@Nullable Map.Entry<StaticBuffer, ColumnValueStore> entry) {
                    return entry != null && !entry.getValue().isEmpty(transaction);
                }
            });
            this.columnSlice = columns;
            this.transaction = transaction;
        }

        @Override
        public RecordIterator<Entry> getEntries() {
            this.ensureOpen();
            if (this.columnSlice == null) {
                throw new IllegalStateException("getEntries() requires SliceQuery to be set.");
            }
            final KeySliceQuery keySlice = new KeySliceQuery(this.currentRow.getKey(), this.columnSlice);
            return new RecordIterator<Entry>(){
                private final Iterator<Entry> items;
                {
                    this.items = ((ColumnValueStore)currentRow.getValue()).getSlice(keySlice, transaction).iterator();
                }

                @Override
                public boolean hasNext() {
                    this.ensureOpen();
                    return this.items.hasNext();
                }

                @Override
                public Entry next() {
                    this.ensureOpen();
                    return this.items.next();
                }

                @Override
                public void close() {
                    isClosed = true;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Column removal not supported");
                }
            };
        }

        @Override
        public boolean hasNext() {
            this.ensureOpen();
            if (null != this.nextRow) {
                return true;
            }
            while (this.rows.hasNext()) {
                this.nextRow = this.rows.next();
                EntryList ents = this.nextRow.getValue().getSlice(new KeySliceQuery(this.nextRow.getKey(), this.columnSlice), this.transaction);
                if (null == ents || 0 >= ents.size()) continue;
                break;
            }
            return null != this.nextRow;
        }

        @Override
        public StaticBuffer next() {
            this.ensureOpen();
            Preconditions.checkNotNull(this.nextRow);
            this.currentRow = this.nextRow;
            this.nextRow = null;
            return this.currentRow.getKey();
        }

        @Override
        public void close() {
            this.isClosed = true;
        }

        private void ensureOpen() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed.");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Key removal not supported");
        }
    }
}

