/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import org.apache.commons.lang.ArrayUtils;

public enum Cmp implements TitanPredicate
{
    EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return true;
        }

        @Override
        public boolean test(Object value, Object condition) {
            if (condition == null) {
                return value == null;
            }
            if (condition.equals(value)) {
                return true;
            }
            if (condition.getClass().isArray()) {
                return ArrayUtils.isEquals((Object)condition, (Object)value);
            }
            return false;
        }

        public String toString() {
            return "=";
        }

        @Override
        public TitanPredicate negate() {
            return NOT_EQUAL;
        }
    }
    ,
    NOT_EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return true;
        }

        @Override
        public boolean test(Object value, Object condition) {
            if (condition == null) {
                return value != null;
            }
            return !condition.equals(value);
        }

        public String toString() {
            return "<>";
        }

        @Override
        public TitanPredicate negate() {
            return EQUAL;
        }
    }
    ,
    LESS_THAN{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtil.compare(value, condition);
            return cmp != null ? cmp < 0 : false;
        }

        public String toString() {
            return "<";
        }

        @Override
        public TitanPredicate negate() {
            return GREATER_THAN_EQUAL;
        }
    }
    ,
    LESS_THAN_EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtil.compare(value, condition);
            return cmp != null ? cmp <= 0 : false;
        }

        public String toString() {
            return "<=";
        }

        @Override
        public TitanPredicate negate() {
            return GREATER_THAN;
        }
    }
    ,
    GREATER_THAN{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtil.compare(value, condition);
            return cmp != null ? cmp > 0 : false;
        }

        public String toString() {
            return ">";
        }

        @Override
        public TitanPredicate negate() {
            return LESS_THAN_EQUAL;
        }
    }
    ,
    GREATER_THAN_EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtil.compare(value, condition);
            return cmp != null ? cmp >= 0 : false;
        }

        public String toString() {
            return ">=";
        }

        @Override
        public TitanPredicate negate() {
            return LESS_THAN;
        }
    };


    @Override
    public boolean hasNegation() {
        return true;
    }

    @Override
    public boolean isQNF() {
        return true;
    }
}

