/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.optimize;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.profile.QueryProfiler;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.HasStepFolder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import com.thinkaurelius.titan.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class TitanGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasStepFolder<S, E>,
Profiling,
HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private int limit = Integer.MAX_VALUE;
    private List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;

    public TitanGraphStep(GraphStep<S, E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.isStartStep(), originalStep.getIds());
        originalStep.getLabels().forEach(arg_0 -> ((TitanGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> {
            TitanTransaction tx = TitanTraversalUtil.getTx(this.traversal);
            TitanGraphQuery<? extends TitanGraphQuery> query = tx.query();
            for (HasContainer condition : this.hasContainers) {
                query.has(condition.getKey(), TitanPredicate.Converter.convert(condition.getBiPredicate()), condition.getValue());
            }
            for (HasStepFolder.OrderEntry order : this.orders) {
                query.orderBy(order.key, order.order);
            }
            if (this.limit != Integer.MAX_VALUE) {
                query.limit(this.limit);
            }
            ((GraphCentricQueryBuilder)query).profiler(this.queryProfiler);
            return Vertex.class.isAssignableFrom(this.returnClass) ? query.vertices().iterator() : query.edges().iterator();
        });
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        Iterables.addAll(this.hasContainers, has);
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }

    public List<HasContainer> getHasContainers() {
        return this.hasContainers;
    }

    public void addHasContainer(HasContainer hasContainer) {
        this.addAll(Collections.singleton(hasContainer));
    }
}

