/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class SimpleTitanProperty<V>
implements TitanProperty<V> {
    private final PropertyKey key;
    private final V value;
    private final InternalRelation relation;

    public SimpleTitanProperty(InternalRelation relation, PropertyKey key, V value) {
        this.key = key;
        this.value = value;
        this.relation = relation;
    }

    @Override
    public PropertyKey propertyKey() {
        return this.key;
    }

    public V value() throws NoSuchElementException {
        return this.value;
    }

    public boolean isPresent() {
        return true;
    }

    public TitanElement element() {
        return this.relation;
    }

    public void remove() {
        Preconditions.checkArgument((!this.relation.isRemoved() ? 1 : 0) != 0, (Object)"Cannot modified removed relation");
        this.relation.it().removePropertyDirect(this.key);
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Property)this);
    }

    public boolean equals(Object oth) {
        return ElementHelper.areEqual((Property)this, (Object)oth);
    }
}

