/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IncidenceCondition<E extends TitanRelation>
extends Literal<E> {
    private final TitanVertex baseVertex;
    private final TitanVertex otherVertex;

    public IncidenceCondition(TitanVertex baseVertex, TitanVertex otherVertex) {
        Preconditions.checkNotNull((Object)baseVertex);
        Preconditions.checkNotNull((Object)otherVertex);
        this.baseVertex = baseVertex;
        this.otherVertex = otherVertex;
    }

    @Override
    public boolean evaluate(E relation) {
        return relation.isEdge() && ((TitanEdge)relation).otherVertex(this.baseVertex).equals(this.otherVertex);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.baseVertex).append((Object)this.otherVertex).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        IncidenceCondition oth = (IncidenceCondition)other;
        return this.baseVertex.equals(oth.baseVertex) && this.otherVertex.equals(oth.otherVertex);
    }

    @Override
    public String toString() {
        return "incidence[" + this.baseVertex + "-" + this.otherVertex + "]";
    }
}

