/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.olap.computer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.MemoryHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class FulgoraMemory
implements Memory.Admin {
    public final Set<String> memoryKeys = new HashSet<String>();
    public Map<String, Object> previousMap;
    public Map<String, Object> currentMap;
    private final AtomicInteger iteration = new AtomicInteger(0);
    private final AtomicLong runtime = new AtomicLong(0L);

    public FulgoraMemory(VertexProgram<?> vertexProgram, Set<MapReduce> mapReducers) {
        this.currentMap = new ConcurrentHashMap<String, Object>();
        this.previousMap = new ConcurrentHashMap<String, Object>();
        if (null != vertexProgram) {
            for (String key : vertexProgram.getMemoryComputeKeys()) {
                MemoryHelper.validateKey((String)key);
                this.memoryKeys.add(key);
            }
        }
        for (MapReduce mapReduce : mapReducers) {
            this.memoryKeys.add(mapReduce.getMemoryKey());
        }
    }

    public Set<String> keys() {
        return this.previousMap.keySet();
    }

    public void incrIteration() {
        this.iteration.getAndIncrement();
    }

    public void setIteration(int iteration) {
        this.iteration.set(iteration);
    }

    public int getIteration() {
        return this.iteration.get();
    }

    public void setRuntime(long runTime) {
        this.runtime.set(runTime);
    }

    public long getRuntime() {
        return this.runtime.get();
    }

    protected void complete() {
        this.iteration.decrementAndGet();
        this.previousMap = this.currentMap;
    }

    protected void completeSubRound() {
        this.previousMap = new ConcurrentHashMap<String, Object>(this.currentMap);
    }

    public boolean isInitialIteration() {
        return this.getIteration() == 0;
    }

    public <R> R get(String key) throws IllegalArgumentException {
        Object r = this.previousMap.get(key);
        if (null == r) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        return (R)r;
    }

    public void incr(String key, long delta) {
        this.checkKeyValue(key, delta);
        this.currentMap.compute(key, (k, v) -> null == v ? delta : delta + (Long)v);
    }

    public void and(String key, boolean bool) {
        this.checkKeyValue(key, bool);
        this.currentMap.compute(key, (k, v) -> null == v ? bool : bool && (Boolean)v != false);
    }

    public void or(String key, boolean bool) {
        this.checkKeyValue(key, bool);
        this.currentMap.compute(key, (k, v) -> null == v ? bool : bool || (Boolean)v != false);
    }

    public void set(String key, Object value) {
        this.checkKeyValue(key, value);
        this.currentMap.put(key, value);
    }

    public String toString() {
        return StringFactory.memoryString((Memory)this);
    }

    private void checkKeyValue(String key, Object value) {
        if (!this.memoryKeys.contains(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)key);
        }
        MemoryHelper.validateValue((Object)value);
    }
}

