/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import java.util.EnumMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class RelationQueryCache
implements AutoCloseable {
    private final Cache<Long, CacheEntry> cache;
    private final EdgeSerializer edgeSerializer;
    private final EnumMap<RelationCategory, SliceQuery> relationTypes;

    public RelationQueryCache(EdgeSerializer edgeSerializer) {
        this(edgeSerializer, 256);
    }

    public RelationQueryCache(EdgeSerializer edgeSerializer, int capacity) {
        this.edgeSerializer = edgeSerializer;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)(capacity * 3 / 2)).initialCapacity(capacity).concurrencyLevel(2).build();
        this.relationTypes = new EnumMap(RelationCategory.class);
        for (RelationCategory rt : RelationCategory.values()) {
            this.relationTypes.put(rt, edgeSerializer.getQuery(rt, false));
        }
    }

    public SliceQuery getQuery(RelationCategory type) {
        return this.relationTypes.get(type);
    }

    public SliceQuery getQuery(final InternalRelationType type, Direction dir) {
        CacheEntry ce;
        try {
            ce = (CacheEntry)this.cache.get((Object)type.longId(), (Callable)new Callable<CacheEntry>(){

                @Override
                public CacheEntry call() throws Exception {
                    return new CacheEntry(RelationQueryCache.this.edgeSerializer, type);
                }
            });
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)("Should not happen: " + e.getMessage()));
        }
        assert (ce != null);
        return ce.get(dir);
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static final class CacheEntry {
        private final SliceQuery in;
        private final SliceQuery out;
        private final SliceQuery both;

        public CacheEntry(EdgeSerializer edgeSerializer, InternalRelationType t) {
            if (t.isPropertyKey()) {
                this.in = this.out = edgeSerializer.getQuery(t, Direction.OUT, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
                this.both = this.out;
            } else {
                this.out = edgeSerializer.getQuery(t, Direction.OUT, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
                this.in = edgeSerializer.getQuery(t, Direction.IN, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
                this.both = edgeSerializer.getQuery(t, Direction.BOTH, new EdgeSerializer.TypedInterval[t.getSortKey().length]);
            }
        }

        public SliceQuery get(Direction dir) {
            switch (dir) {
                case IN: {
                    return this.in;
                }
                case OUT: {
                    return this.out;
                }
                case BOTH: {
                    return this.both;
                }
            }
            throw new AssertionError((Object)("Unknown direction: " + dir));
        }
    }
}

