/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.TitanFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class TitanConstants {
    public static final String TITAN_PROPERTIES_FILE = "titan.internal.properties";
    public static final String VERSION;
    public static final List<String> COMPATIBLE_VERSIONS;

    static {
        Package p = TitanConstants.class.getPackage();
        Preconditions.checkNotNull((Object)p, (Object)("Unable to load package containing class " + TitanConstants.class));
        String packageName = p.getName();
        Preconditions.checkNotNull((Object)packageName, (Object)("Unable to get name of package containing " + TitanConstants.class));
        String resourceName = packageName.replace('.', '/') + "/" + TITAN_PROPERTIES_FILE;
        InputStream is = TitanFactory.class.getClassLoader().getResourceAsStream(resourceName);
        Preconditions.checkNotNull((Object)is, (Object)("Unable to locate classpath resource " + resourceName + " containing Titan version"));
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load properties from " + resourceName, e);
        }
        VERSION = props.getProperty("titan.version");
        ImmutableList.Builder b = ImmutableList.builder();
        for (String v : props.getProperty("titan.compatible-versions", "").split(",")) {
            if ((v = v.trim()).isEmpty()) continue;
            b.add((Object)v);
        }
        COMPATIBLE_VERSIONS = b.build();
    }
}

