/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.codahale.metrics.Timer;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StoreMetaData;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.MetricInstrumentedStore;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.util.List;
import java.util.Map;

public class MetricInstrumentedStoreManager
implements KeyColumnValueStoreManager {
    public static final String M_OPEN_DATABASE = "openDatabase";
    public static final String M_START_TX = "startTransaction";
    public static final String M_CLOSE_MANAGER = "closeManager";
    public static final String GLOBAL_PREFIX = "global";
    private final KeyColumnValueStoreManager backend;
    private final boolean mergeStoreMetrics;
    private final String mergedMetricsName;
    private final String managerMetricsName;

    public MetricInstrumentedStoreManager(KeyColumnValueStoreManager backend, String managerMetricsName, boolean mergeStoreMetrics, String mergedMetricsName) {
        this.backend = backend;
        this.mergeStoreMetrics = mergeStoreMetrics;
        this.mergedMetricsName = mergedMetricsName;
        this.managerMetricsName = managerMetricsName;
    }

    private String getMetricsStoreName(String storeName) {
        return this.mergeStoreMetrics ? this.mergedMetricsName : storeName;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        MetricManager.INSTANCE.getCounter(GLOBAL_PREFIX, this.managerMetricsName, M_OPEN_DATABASE, "calls").inc();
        return new MetricInstrumentedStore(this.backend.openDatabase(name, metaData), this.getMetricsStoreName(name));
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        if (!txh.getConfiguration().hasGroupName()) {
            this.backend.mutateMany(mutations, txh);
        }
        String prefix = txh.getConfiguration().getGroupName();
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, this.managerMetricsName, "mutate", "calls").inc();
        Timer.Context tc = mgr.getTimer(prefix, this.managerMetricsName, "mutate", "time").time();
        try {
            this.backend.mutateMany(mutations, txh);
        }
        catch (BackendException e) {
            mgr.getCounter(prefix, this.managerMetricsName, "mutate", "exceptions").inc();
            throw e;
        }
        catch (RuntimeException e) {
            mgr.getCounter(prefix, this.managerMetricsName, "mutate", "exceptions").inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    @Override
    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws BackendException {
        MetricManager.INSTANCE.getCounter(GLOBAL_PREFIX, this.managerMetricsName, M_START_TX, "calls").inc();
        return this.backend.beginTransaction(config);
    }

    @Override
    public void close() throws BackendException {
        this.backend.close();
        MetricManager.INSTANCE.getCounter(GLOBAL_PREFIX, this.managerMetricsName, M_CLOSE_MANAGER, "calls").inc();
    }

    @Override
    public void clearStorage() throws BackendException {
        this.backend.clearStorage();
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.backend.getFeatures();
    }

    @Override
    public String getName() {
        return this.backend.getName();
    }

    @Override
    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        return this.backend.getLocalKeyPartition();
    }
}

