/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLocker;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLockerSerializer;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.TimestampRid;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLockCleanerRunnable
implements Runnable {
    private final KeyColumnValueStore store;
    private final KeyColumn target;
    private final ConsistentKeyLockerSerializer serializer;
    private final StoreTransaction tx;
    private final Instant cutoff;
    private TimestampProvider times;
    private static final Logger log = LoggerFactory.getLogger(StandardLockCleanerRunnable.class);

    public StandardLockCleanerRunnable(KeyColumnValueStore store, KeyColumn target, StoreTransaction tx, ConsistentKeyLockerSerializer serializer, Instant cutoff, TimestampProvider times) {
        this.store = store;
        this.target = target;
        this.serializer = serializer;
        this.tx = tx;
        this.cutoff = cutoff;
        this.times = times;
    }

    @Override
    public void run() {
        try {
            this.runWithExceptions();
        }
        catch (BackendException e) {
            log.warn("Expired lock cleaner failed", (Throwable)e);
        }
    }

    private void runWithExceptions() throws BackendException {
        StaticBuffer lockKey = this.serializer.toLockKey(this.target.getKey(), this.target.getColumn());
        EntryList locks = this.store.getSlice(new KeySliceQuery(lockKey, ConsistentKeyLocker.LOCK_COL_START, ConsistentKeyLocker.LOCK_COL_END), this.tx);
        ImmutableList.Builder b = ImmutableList.builder();
        for (Entry lc : locks) {
            TimestampRid tr = this.serializer.fromLockColumn(lc.getColumn(), this.times);
            if (tr.getTimestamp().isBefore(this.cutoff)) {
                log.info("Deleting expired lock on {} by rid {} with timestamp {} (before or at cutoff {})", new Object[]{this.target, tr.getRid(), tr.getTimestamp(), this.cutoff});
                b.add((Object)lc.getColumn());
                continue;
            }
            log.debug("Ignoring lock on {} by rid {} with timestamp {} (timestamp is after cutoff {})", new Object[]{this.target, tr.getRid(), tr.getTimestamp(), this.cutoff});
        }
        ImmutableList dels = b.build();
        if (!dels.isEmpty()) {
            this.store.mutate(lockKey, (List<Entry>)ImmutableList.of(), (List<StaticBuffer>)dels, this.tx);
            log.info("Deleted {} expired locks (before or at cutoff {})", (Object)dels.size(), (Object)this.cutoff);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cutoff == null ? 0 : this.cutoff.hashCode());
        result = 31 * result + (this.serializer == null ? 0 : this.serializer.hashCode());
        result = 31 * result + (this.store == null ? 0 : this.store.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.tx == null ? 0 : this.tx.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardLockCleanerRunnable other = (StandardLockCleanerRunnable)obj;
        if (this.cutoff == null ? other.cutoff != null : !this.cutoff.equals(other.cutoff)) {
            return false;
        }
        if (this.serializer == null ? other.serializer != null : !this.serializer.equals(other.serializer)) {
            return false;
        }
        if (this.store == null ? other.store != null : !this.store.equals(other.store)) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        return !(this.tx == null ? other.tx != null : !this.tx.equals(other.tx));
    }
}

