/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Contain implements TitanPredicate
{
    IN{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object[])new Object[]{condition});
            Collection col = (Collection)condition;
            return col.contains(value);
        }

        @Override
        public TitanPredicate negate() {
            return NOT_IN;
        }
    }
    ,
    NOT_IN{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object[])new Object[]{condition});
            Collection col = (Collection)condition;
            return !col.contains(value);
        }

        @Override
        public TitanPredicate negate() {
            return IN;
        }
    };

    private static final Logger log;

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean isValidCondition(Object condition) {
        return condition != null && condition instanceof Collection;
    }

    @Override
    public boolean hasNegation() {
        return true;
    }

    @Override
    public boolean isQNF() {
        return false;
    }

    static {
        log = LoggerFactory.getLogger(Contain.class);
    }
}

