/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction.indexcache;

import com.google.common.collect.HashMultimap;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.graphdb.transaction.indexcache.IndexCache;
import java.util.ArrayList;

public class ConcurrentIndexCache
implements IndexCache {
    private final HashMultimap<Object, TitanVertexProperty> map = HashMultimap.create();

    @Override
    public synchronized void add(TitanVertexProperty property) {
        this.map.put(property.value(), (Object)property);
    }

    @Override
    public synchronized void remove(TitanVertexProperty property) {
        this.map.remove(property.value(), (Object)property);
    }

    @Override
    public synchronized Iterable<TitanVertexProperty> get(Object value, PropertyKey key) {
        ArrayList<TitanVertexProperty> result = new ArrayList<TitanVertexProperty>(4);
        for (TitanVertexProperty p : this.map.get(value)) {
            if (!p.propertyKey().equals(key)) continue;
            result.add(p);
        }
        return result;
    }
}

