/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.optimize;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.profile.QueryProfiler;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.HasStepFolder;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.MultiQueriable;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import com.thinkaurelius.titan.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class TitanPropertiesStep<E>
extends PropertiesStep<E>
implements HasStepFolder<Element, E>,
Profiling,
MultiQueriable<Element, E> {
    private boolean initialized = false;
    private boolean useMultiQuery = false;
    private Map<TitanVertex, Iterable<? extends TitanProperty>> multiQueryResults = null;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final List<HasContainer> hasContainers;
    private int limit = Integer.MAX_VALUE;
    private List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public TitanPropertiesStep(PropertiesStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnType(), originalStep.getPropertyKeys());
        originalStep.getLabels().forEach(arg_0 -> ((TitanPropertiesStep)this).addLabel(arg_0));
        this.hasContainers = new ArrayList<HasContainer>();
        this.limit = Integer.MAX_VALUE;
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
    }

    private <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        String[] keys = this.getPropertyKeys();
        query.keys(keys);
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), TitanPredicate.Converter.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    private Iterator<E> convertIterator(Iterable<? extends TitanProperty> iterable) {
        if (this.getReturnType().forProperties()) {
            return iterable.iterator();
        }
        assert (this.getReturnType().forValues());
        return Iterators.transform(iterable.iterator(), p -> p.value());
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        assert (this.getReturnType().forProperties() || this.orders.isEmpty() && this.hasContainers.isEmpty());
        if (!this.starts.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        ArrayList elements = new ArrayList();
        this.starts.forEachRemaining(v -> elements.add(v));
        this.starts.add(elements.iterator());
        assert (elements.size() > 0);
        boolean bl = this.useMultiQuery = this.useMultiQuery && elements.stream().noneMatch(e -> !(e.get() instanceof Vertex));
        if (this.useMultiQuery) {
            TitanMultiVertexQuery<? extends TitanMultiVertexQuery> mquery = TitanTraversalUtil.getTx(this.traversal).multiQuery(new TitanVertex[0]);
            elements.forEach(e -> mquery.addVertex((Vertex)e.get()));
            this.makeQuery(mquery);
            this.multiQueryResults = mquery.properties();
        }
    }

    protected Traverser<E> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    protected Iterator<E> flatMap(Traverser.Admin<Element> traverser) {
        Iterator iter;
        if (this.useMultiQuery) {
            assert (this.multiQueryResults != null);
            return this.convertIterator(this.multiQueryResults.get(traverser.get()));
        }
        if (traverser.get() instanceof Vertex) {
            TitanVertexQuery<? extends TitanVertexQuery> query = this.makeQuery(TitanTraversalUtil.getTitanVertex(traverser).query());
            return this.convertIterator(query.properties());
        }
        if (this.getReturnType().forValues()) {
            assert (this.orders.isEmpty() && this.hasContainers.isEmpty());
            iter = ((Element)traverser.get()).values(this.getPropertyKeys());
        } else {
            assert (this.orders.isEmpty());
            if (!this.hasContainers.isEmpty()) {
                return Collections.emptyIterator();
            }
            iter = ((Element)traverser.get()).properties(this.getPropertyKeys());
        }
        if (this.limit != Integer.MAX_VALUE) {
            iter = Iterators.limit((Iterator)iter, (int)this.limit);
        }
        return iter;
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public TitanPropertiesStep<E> clone() {
        TitanPropertiesStep clone = (TitanPropertiesStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        Iterables.addAll(this.hasContainers, has);
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

