/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop.io.graphson;

import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import java.io.IOException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class TitanGraphSONModule
extends SimpleModule {
    private static final TitanGraphSONModule INSTANCE = new TitanGraphSONModule();

    private TitanGraphSONModule() {
        this.addSerializer(RelationIdentifier.class, (JsonSerializer)new RelationIdentifierSerializer());
        this.addSerializer(Geoshape.class, (JsonSerializer)new Geoshape.GeoshapeGsonSerializer());
        this.addDeserializer(RelationIdentifier.class, (JsonDeserializer)new RelationIdentifierDeserializer());
        this.addDeserializer(Geoshape.class, (JsonDeserializer)new Geoshape.GeoshapeGsonDeserializer());
    }

    public static final TitanGraphSONModule getInstance() {
        return INSTANCE;
    }

    public static class RelationIdentifierDeserializer
    extends StdDeserializer<RelationIdentifier> {
        public RelationIdentifierDeserializer() {
            super(RelationIdentifier.class);
        }

        public RelationIdentifier deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return RelationIdentifier.parse(jsonParser.getValueAsString());
        }
    }

    public static class RelationIdentifierSerializer
    extends StdSerializer<RelationIdentifier> {
        public RelationIdentifierSerializer() {
            super(RelationIdentifier.class);
        }

        public void serialize(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            jsonGenerator.writeString(relationIdentifier.toString());
        }

        public void serializeWithType(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(RelationIdentifier.class.getName());
            jsonGenerator.writeString(relationIdentifier.toString());
            jsonGenerator.writeEndArray();
        }
    }
}

