/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.tinkerpop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.diskstorage.util.Hex;
import com.thinkaurelius.titan.graphdb.olap.computer.FulgoraGraphComputer;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.tinkerpop.ElementUtils;
import com.thinkaurelius.titan.graphdb.tinkerpop.TitanBlueprintsGraph;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.graphdb.util.ElementHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadedTransaction;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanBlueprintsTransaction
implements TitanTransaction {
    private static final Logger log = LoggerFactory.getLogger(TitanBlueprintsTransaction.class);

    protected abstract TitanBlueprintsGraph getGraph();

    public Graph.Features features() {
        return this.getGraph().features();
    }

    public Graph.Variables variables() {
        return this.getGraph().variables();
    }

    public Configuration configuration() {
        return this.getGraph().configuration();
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        return this.getGraph().io(builder);
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        return this.getGraph().compute(graphComputerClass);
    }

    public FulgoraGraphComputer compute() throws IllegalArgumentException {
        return this.getGraph().compute();
    }

    @Override
    public TitanVertex addVertex(Object ... keyValues) {
        org.apache.tinkerpop.gremlin.structure.util.ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (org.apache.tinkerpop.gremlin.structure.util.ElementHelper.getIdValue((Object[])keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        Object labelValue = null;
        for (int i = 0; i < keyValues.length; i += 2) {
            if (!keyValues[i].equals(T.label)) continue;
            labelValue = keyValues[i + 1];
            Preconditions.checkArgument((labelValue instanceof VertexLabel || labelValue instanceof String ? 1 : 0) != 0, (String)"Expected a string or VertexLabel as the vertex label argument, but got: %s", (Object[])new Object[]{labelValue});
            if (!(labelValue instanceof String)) continue;
            org.apache.tinkerpop.gremlin.structure.util.ElementHelper.validateLabel((String)((String)labelValue));
        }
        VertexLabel label = BaseVertexLabel.DEFAULT_VERTEXLABEL;
        if (labelValue != null) {
            label = labelValue instanceof VertexLabel ? (VertexLabel)labelValue : this.getOrCreateVertexLabel((String)labelValue);
        }
        TitanVertex vertex = this.addVertex(null, label);
        ElementHelper.attachProperties(vertex, keyValues);
        return vertex;
    }

    public Iterator<Vertex> vertices(Object ... vids) {
        if (vids == null || vids.length == 0) {
            return this.getVertices(new long[0]).iterator();
        }
        ElementUtils.verifyArgsMustBeEitherIdorElement(vids);
        long[] ids = new long[vids.length];
        int pos = 0;
        for (int i = 0; i < vids.length; ++i) {
            long id = ElementUtils.getVertexId(vids[i]);
            if (id <= 0L) continue;
            ids[pos++] = id;
        }
        if (pos == 0) {
            return Collections.emptyIterator();
        }
        if (pos < ids.length) {
            ids = Arrays.copyOf(ids, pos);
        }
        return this.getVertices(ids).iterator();
    }

    public Iterator<Edge> edges(Object ... eids) {
        if (eids == null || eids.length == 0) {
            return this.getEdges(new RelationIdentifier[0]).iterator();
        }
        ElementUtils.verifyArgsMustBeEitherIdorElement(eids);
        RelationIdentifier[] ids = new RelationIdentifier[eids.length];
        int pos = 0;
        for (int i = 0; i < eids.length; ++i) {
            RelationIdentifier id = ElementUtils.getEdgeId(eids[i]);
            if (id == null) continue;
            ids[pos++] = id;
        }
        if (pos == 0) {
            return Collections.emptyIterator();
        }
        if (pos < ids.length) {
            ids = Arrays.copyOf(ids, pos);
        }
        return this.getEdges(ids).iterator();
    }

    public String toString() {
        int ihc = System.identityHashCode(this);
        String ihcString = String.format("0x%s", Hex.bytesToHex((byte)(ihc >>> 24 & 0xFF), (byte)(ihc >>> 16 & 0xFF), (byte)(ihc >>> 8 & 0xFF), (byte)(ihc & 0xFF)));
        return StringFactory.graphString((Graph)this, (String)ihcString);
    }

    public Transaction tx() {
        return new AbstractThreadedTransaction(this.getGraph()){

            public void doOpen() {
                if (TitanBlueprintsTransaction.this.isClosed()) {
                    throw new IllegalStateException("Cannot re-open a closed transaction.");
                }
            }

            public void doCommit() {
                TitanBlueprintsTransaction.this.commit();
            }

            public void doRollback() {
                TitanBlueprintsTransaction.this.rollback();
            }

            public <R> Transaction.Workload<R> submit(Function<Graph, R> graphRFunction) {
                throw new UnsupportedOperationException("Titan does not support nested transactions. Call submit on a TitanGraph not an individual transaction.");
            }

            public <G extends Graph> G createThreadedTx() {
                throw new UnsupportedOperationException("Titan does not support nested transactions.");
            }

            public boolean isOpen() {
                return TitanBlueprintsTransaction.this.isOpen();
            }

            public void doClose() {
                TitanBlueprintsTransaction.this.getGraph().tinkerpopTxContainer.close((Transaction)this);
                super.doClose();
            }
        };
    }

    @Override
    public void close() {
        this.tx().close();
    }
}

