/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.idassigner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDBlockSizer;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPool;
import com.thinkaurelius.titan.graphdb.database.idassigner.IDPoolExhaustedException;
import com.thinkaurelius.titan.graphdb.database.idassigner.StandardIDPool;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.IDPlacementStrategy;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionAssignment;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.PartitionIDRange;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.ReassignableRelation;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.util.stats.NumberUtil;
import java.time.Duration;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class VertexIDAssigner
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(VertexIDAssigner.class);
    private static final int MAX_PARTITION_RENEW_ATTEMPTS = 1000;
    public static final ConfigOption<String> PLACEMENT_STRATEGY = new ConfigOption<String>(GraphDatabaseConfiguration.IDS_NS, "placement", "Name of the vertex placement strategy or full class name", ConfigOption.Type.MASKABLE, "simple");
    private static final Map<String, String> REGISTERED_PLACEMENT_STRATEGIES = ImmutableMap.of((Object)"simple", (Object)SimpleBulkPlacementStrategy.class.getName());
    final ConcurrentMap<Integer, PartitionIDPool> idPools;
    final StandardIDPool schemaIdPool;
    final StandardIDPool partitionVertexIdPool;
    private final IDAuthority idAuthority;
    private final IDManager idManager;
    private final IDPlacementStrategy placementStrategy;
    private final Duration renewTimeoutMS;
    private final double renewBufferPercentage;
    private final int partitionIdBound;
    private final boolean hasLocalPartitions;

    public VertexIDAssigner(Configuration config, IDAuthority idAuthority, StoreFeatures idAuthFeatures) {
        Preconditions.checkNotNull((Object)idAuthority);
        this.idAuthority = idAuthority;
        int partitionBits = NumberUtil.getPowerOf2(config.get(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, new String[0]).intValue());
        this.idManager = new IDManager(partitionBits);
        Preconditions.checkArgument((this.idManager.getPartitionBound() <= Integer.MAX_VALUE && this.idManager.getPartitionBound() > 0L ? 1 : 0) != 0);
        this.partitionIdBound = (int)this.idManager.getPartitionBound();
        this.hasLocalPartitions = idAuthFeatures.hasLocalKeyPartition();
        this.placementStrategy = (IDPlacementStrategy)Backend.getImplementationClass(config, config.get(PLACEMENT_STRATEGY, new String[0]), REGISTERED_PLACEMENT_STRATEGIES);
        this.placementStrategy.injectIDManager(this.idManager);
        log.debug("Partition IDs? [{}], Local Partitions? [{}]", (Object)true, (Object)this.hasLocalPartitions);
        long baseBlockSize = config.get(GraphDatabaseConfiguration.IDS_BLOCK_SIZE, new String[0]).intValue();
        idAuthority.setIDBlockSizer(new SimpleVertexIDBlockSizer(baseBlockSize));
        this.renewTimeoutMS = config.get(GraphDatabaseConfiguration.IDS_RENEW_TIMEOUT, new String[0]);
        this.renewBufferPercentage = config.get(GraphDatabaseConfiguration.IDS_RENEW_BUFFER_PERCENTAGE, new String[0]);
        this.idPools = new ConcurrentHashMap<Integer, PartitionIDPool>(this.partitionIdBound);
        VertexIDAssigner vertexIDAssigner = this;
        this.schemaIdPool = new StandardIDPool(idAuthority, 0, PoolType.SCHEMA.getIDNamespace(), vertexIDAssigner.idManager.getSchemaCountBound(), this.renewTimeoutMS, this.renewBufferPercentage);
        this.partitionVertexIdPool = new StandardIDPool(idAuthority, 1, PoolType.PARTITIONED_VERTEX.getIDNamespace(), PoolType.PARTITIONED_VERTEX.getCountBound(this.idManager), this.renewTimeoutMS, this.renewBufferPercentage);
        this.setLocalPartitions(partitionBits);
    }

    private void setLocalPartitionsToGlobal(int partitionBits) {
        this.placementStrategy.setLocalPartitionBounds(PartitionIDRange.getGlobalRange(partitionBits));
    }

    private void setLocalPartitions(int partitionBits) {
        if (!this.hasLocalPartitions) {
            this.setLocalPartitionsToGlobal(partitionBits);
        } else {
            Object partitionRanges = ImmutableList.of();
            try {
                partitionRanges = PartitionIDRange.getIDRanges(partitionBits, this.idAuthority.getLocalIDPartition());
            }
            catch (Throwable e) {
                log.error("Could not process local id partitions", e);
            }
            if (!partitionRanges.isEmpty()) {
                log.info("Setting individual partition bounds: {}", partitionRanges);
                this.placementStrategy.setLocalPartitionBounds((List<PartitionIDRange>)partitionRanges);
            } else {
                this.setLocalPartitionsToGlobal(partitionBits);
            }
        }
    }

    public IDManager getIDManager() {
        return this.idManager;
    }

    @Override
    public synchronized void close() {
        this.schemaIdPool.close();
        for (PartitionIDPool pool : this.idPools.values()) {
            pool.close();
        }
        this.idPools.clear();
    }

    public void assignID(InternalRelation relation) {
        this.assignID(relation, null);
    }

    public void assignID(InternalVertex vertex, VertexLabel label) {
        Preconditions.checkArgument((vertex != null && label != null ? 1 : 0) != 0);
        this.assignID((InternalElement)vertex, VertexIDAssigner.getVertexIDType(label));
    }

    private void assignID(InternalElement element, IDManager.VertexIDType vertexIDType) {
        for (int attempt = 0; attempt < 1000; ++attempt) {
            InternalRelation relation;
            long partitionID = -1L;
            if (element instanceof TitanSchemaVertex) {
                partitionID = 0L;
            } else if (element instanceof TitanVertex) {
                partitionID = vertexIDType == IDManager.VertexIDType.PartitionedVertex ? 1L : (long)this.placementStrategy.getPartition(element);
            } else if (element instanceof InternalRelation) {
                relation = (InternalRelation)element;
                if (attempt < relation.getLen()) {
                    InternalVertex incident = relation.getVertex(attempt);
                    Preconditions.checkArgument((boolean)incident.hasId());
                    if (IDManager.VertexIDType.PartitionedVertex.is(incident.longId()) && !relation.isProperty()) continue;
                    partitionID = this.getPartitionID(incident);
                } else {
                    partitionID = this.placementStrategy.getPartition(element);
                }
            }
            try {
                this.assignID(element, partitionID, vertexIDType);
            }
            catch (IDPoolExhaustedException e) {
                continue;
            }
            assert (element.hasId());
            if (element instanceof InternalRelation) {
                relation = (InternalRelation)element;
                if (relation.isProperty() && this.isPartitionedAt(relation, 0)) {
                    InternalVertex vertex = relation.getVertex(0);
                    ((ReassignableRelation)((Object)relation)).setVertexAt(0, vertex.tx().getInternalVertex(this.idManager.getCanonicalVertexId(vertex.longId())));
                } else if (relation.isEdge()) {
                    for (int pos = 0; pos < relation.getArity(); ++pos) {
                        if (!this.isPartitionedAt(relation, pos)) continue;
                        InternalVertex incident = relation.getVertex(pos);
                        int otherpos = (pos + 1) % 2;
                        long newPartition = ((InternalRelationType)relation.getType()).multiplicity().isUnique(EdgeDirection.fromPosition(pos)) ? this.idManager.getPartitionId(this.idManager.getCanonicalVertexId(incident.longId())) : (!this.isPartitionedAt(relation, otherpos) ? this.getPartitionID(relation.getVertex(otherpos)) : this.idManager.getPartitionHashForId(relation.longId()));
                        if (this.idManager.getPartitionId(incident.longId()) == newPartition) continue;
                        ((ReassignableRelation)((Object)relation)).setVertexAt(pos, incident.tx().getOtherPartitionVertex(incident, newPartition));
                    }
                }
            }
            return;
        }
        throw new IDPoolExhaustedException("Could not find non-exhausted partition ID Pool after 1000 attempts");
    }

    private final boolean isPartitionedAt(InternalRelation relation, int position) {
        return this.idManager.isPartitionedVertex(relation.getVertex(position).longId());
    }

    public void assignIDs(Iterable<InternalRelation> addedRelations) {
        if (!this.placementStrategy.supportsBulkPlacement()) {
            for (InternalRelation relation : addedRelations) {
                for (int i = 0; i < relation.getArity(); ++i) {
                    InternalVertex vertex = relation.getVertex(i);
                    if (vertex.hasId()) continue;
                    this.assignID((InternalElement)vertex, VertexIDAssigner.getVertexIDType(vertex));
                }
                this.assignID(relation);
            }
        } else {
            HashMap<InternalVertex, PartitionAssignment> assignments = new HashMap<InternalVertex, PartitionAssignment>();
            for (InternalRelation relation : addedRelations) {
                for (int i = 0; i < relation.getArity(); ++i) {
                    InternalVertex vertex = relation.getVertex(i);
                    if (vertex.hasId()) continue;
                    assert (!(vertex instanceof TitanSchemaVertex));
                    if (vertex.vertexLabel().isPartitioned()) {
                        this.assignID((InternalElement)vertex, VertexIDAssigner.getVertexIDType(vertex));
                        continue;
                    }
                    assignments.put(vertex, PartitionAssignment.EMPTY);
                }
            }
            log.trace("Bulk id assignment for {} vertices", (Object)assignments.size());
            for (int attempt = 0; attempt < 1000 && assignments != null && !assignments.isEmpty(); ++attempt) {
                this.placementStrategy.getPartitions(assignments);
                HashMap leftOvers = null;
                Iterator iter = assignments.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    try {
                        this.assignID((InternalElement)entry.getKey(), ((PartitionAssignment)entry.getValue()).getPartitionID(), VertexIDAssigner.getVertexIDType((TitanVertex)entry.getKey()));
                        Preconditions.checkArgument((boolean)((InternalVertex)entry.getKey()).hasId());
                    }
                    catch (IDPoolExhaustedException e) {
                        if (leftOvers == null) {
                            leftOvers = new HashMap();
                        }
                        leftOvers.put(entry.getKey(), PartitionAssignment.EMPTY);
                        break;
                    }
                }
                if (leftOvers != null) {
                    while (iter.hasNext()) {
                        leftOvers.put(iter.next().getKey(), PartitionAssignment.EMPTY);
                    }
                    log.debug("Exhausted ID Pool in bulk assignment. Left-over vertices {}", (Object)leftOvers.size());
                }
                assignments = leftOvers;
            }
            if (assignments != null && !assignments.isEmpty()) {
                throw new IDPoolExhaustedException("Could not find non-exhausted partition ID Pool after 1000 attempts");
            }
            for (InternalRelation relation : addedRelations) {
                this.assignID(relation);
            }
        }
    }

    private final long getPartitionID(InternalVertex v) {
        long vid = v.longId();
        if (IDManager.VertexIDType.Schema.is(vid)) {
            return 0L;
        }
        return this.idManager.getPartitionId(vid);
    }

    private void assignID(InternalElement element, long partitionIDl, IDManager.VertexIDType userVertexIDType) {
        long count;
        Preconditions.checkNotNull((Object)element);
        Preconditions.checkArgument((!element.hasId() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(element instanceof TitanRelation ^ userVertexIDType != null));
        Preconditions.checkArgument((partitionIDl >= 0L && partitionIDl < (long)this.partitionIdBound ? 1 : 0) != 0, (Object)partitionIDl);
        int partitionID = (int)partitionIDl;
        if (element instanceof TitanSchemaVertex) {
            Preconditions.checkArgument((partitionID == 0 ? 1 : 0) != 0);
            count = this.schemaIdPool.nextID();
        } else if (userVertexIDType == IDManager.VertexIDType.PartitionedVertex) {
            Preconditions.checkArgument((partitionID == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.partitionVertexIdPool != null ? 1 : 0) != 0);
            count = this.partitionVertexIdPool.nextID();
        } else {
            IDPool idPool;
            PartitionIDPool partitionPool = (PartitionIDPool)this.idPools.get(partitionID);
            if (partitionPool == null) {
                partitionPool = new PartitionIDPool(partitionID, this.idAuthority, this.idManager, this.renewTimeoutMS, this.renewBufferPercentage);
                this.idPools.putIfAbsent(partitionID, partitionPool);
                partitionPool = (PartitionIDPool)this.idPools.get(partitionID);
            }
            Preconditions.checkNotNull((Object)partitionPool);
            if (partitionPool.isExhausted()) {
                this.placementStrategy.exhaustedPartition(partitionID);
                throw new IDPoolExhaustedException("Exhausted id pool for partition: " + partitionID);
            }
            if (element instanceof TitanRelation) {
                idPool = partitionPool.getPool(PoolType.RELATION);
            } else {
                Preconditions.checkArgument((userVertexIDType != null ? 1 : 0) != 0);
                idPool = partitionPool.getPool(PoolType.getPoolTypeFor(userVertexIDType));
            }
            try {
                count = idPool.nextID();
                partitionPool.accessed();
            }
            catch (IDPoolExhaustedException e) {
                log.debug("Pool exhausted for partition id {}", (Object)partitionID);
                this.placementStrategy.exhaustedPartition(partitionID);
                partitionPool.exhaustedIdPool();
                throw e;
            }
        }
        long elementId = element instanceof InternalRelation ? this.idManager.getRelationID(count, partitionID) : (element instanceof PropertyKey ? IDManager.getSchemaId(IDManager.VertexIDType.UserPropertyKey, count) : (element instanceof EdgeLabel ? IDManager.getSchemaId(IDManager.VertexIDType.UserEdgeLabel, count) : (element instanceof VertexLabel ? IDManager.getSchemaId(IDManager.VertexIDType.VertexLabel, count) : (element instanceof TitanSchemaVertex ? IDManager.getSchemaId(IDManager.VertexIDType.GenericSchemaType, count) : this.idManager.getVertexID(count, partitionID, userVertexIDType)))));
        Preconditions.checkArgument((elementId >= 0L ? 1 : 0) != 0);
        element.setId(elementId);
    }

    private static IDManager.VertexIDType getVertexIDType(VertexLabel vlabel) {
        if (vlabel.isPartitioned()) {
            return IDManager.VertexIDType.PartitionedVertex;
        }
        if (vlabel.isStatic()) {
            return IDManager.VertexIDType.UnmodifiableVertex;
        }
        return IDManager.VertexIDType.NormalVertex;
    }

    private static IDManager.VertexIDType getVertexIDType(TitanVertex v) {
        return VertexIDAssigner.getVertexIDType(v.vertexLabel());
    }

    private static class PartitionIDPool
    extends EnumMap<PoolType, IDPool> {
        private volatile long lastAccess;
        private volatile boolean exhausted;

        PartitionIDPool(int partitionID, IDAuthority idAuthority, IDManager idManager, Duration renewTimeoutMS, double renewBufferPercentage) {
            super(PoolType.class);
            for (PoolType type : PoolType.values()) {
                if (!type.hasOnePerPartition()) continue;
                this.put(type, new StandardIDPool(idAuthority, partitionID, type.getIDNamespace(), type.getCountBound(idManager), renewTimeoutMS, renewBufferPercentage));
            }
        }

        public IDPool getPool(PoolType type) {
            Preconditions.checkArgument((!this.exhausted && type.hasOnePerPartition() ? 1 : 0) != 0);
            return (IDPool)super.get((Object)type);
        }

        public void close() {
            for (IDPool pool : this.values()) {
                pool.close();
            }
            super.clear();
        }

        public void exhaustedIdPool() {
            this.exhausted = true;
            this.close();
        }

        public boolean isExhausted() {
            return this.exhausted;
        }

        public void accessed() {
            this.lastAccess = System.currentTimeMillis();
        }

        public long getLastAccess() {
            return this.lastAccess;
        }
    }

    private static enum PoolType {
        NORMAL_VERTEX,
        UNMODIFIABLE_VERTEX,
        PARTITIONED_VERTEX,
        RELATION,
        SCHEMA;


        public int getIDNamespace() {
            return this.ordinal();
        }

        public long getCountBound(IDManager idManager) {
            switch (this) {
                case NORMAL_VERTEX: 
                case UNMODIFIABLE_VERTEX: 
                case PARTITIONED_VERTEX: {
                    return idManager.getVertexCountBound();
                }
                case RELATION: {
                    return idManager.getRelationCountBound();
                }
                case SCHEMA: {
                    return idManager.getSchemaCountBound();
                }
            }
            throw new AssertionError((Object)("Unrecognized type: " + (Object)((Object)this)));
        }

        public boolean hasOnePerPartition() {
            switch (this) {
                case NORMAL_VERTEX: 
                case UNMODIFIABLE_VERTEX: 
                case RELATION: {
                    return true;
                }
            }
            return false;
        }

        public static PoolType getPoolTypeFor(IDManager.VertexIDType idType) {
            if (idType == IDManager.VertexIDType.NormalVertex) {
                return NORMAL_VERTEX;
            }
            if (idType == IDManager.VertexIDType.UnmodifiableVertex) {
                return UNMODIFIABLE_VERTEX;
            }
            if (idType == IDManager.VertexIDType.PartitionedVertex) {
                return PARTITIONED_VERTEX;
            }
            if (IDManager.VertexIDType.Schema.isSubType(idType)) {
                return SCHEMA;
            }
            throw new IllegalArgumentException("Invalid id type: " + (Object)((Object)idType));
        }

        public static PoolType getPoolType(int idNamespace) {
            Preconditions.checkArgument((idNamespace >= 0 && idNamespace < PoolType.values().length ? 1 : 0) != 0);
            return PoolType.values()[idNamespace];
        }
    }

    private class SimpleVertexIDBlockSizer
    implements IDBlockSizer {
        private final long baseBlockSize;

        SimpleVertexIDBlockSizer(long size) {
            Preconditions.checkArgument((size > 0L && size < Integer.MAX_VALUE ? 1 : 0) != 0);
            this.baseBlockSize = size;
        }

        @Override
        public long getBlockSize(int idNamespace) {
            switch (PoolType.getPoolType(idNamespace)) {
                case NORMAL_VERTEX: {
                    return this.baseBlockSize;
                }
                case UNMODIFIABLE_VERTEX: {
                    return Math.max(10L, this.baseBlockSize / 10L);
                }
                case PARTITIONED_VERTEX: {
                    return Math.max(10L, this.baseBlockSize / 100L);
                }
                case RELATION: {
                    return this.baseBlockSize * 8L;
                }
                case SCHEMA: {
                    return 50L;
                }
            }
            throw new IllegalArgumentException("Unrecognized pool type");
        }

        @Override
        public long getIdUpperBound(int idNamespace) {
            return PoolType.getPoolType(idNamespace).getCountBound(VertexIDAssigner.this.idManager);
        }
    }
}

