/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.NoLock;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ColumnValueStore {
    private static final double SIZE_THRESHOLD = 0.66;
    private Data data = new Data(new Entry[0], 0);
    private ReentrantLock lock = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty(StoreTransaction txh) {
        Lock lock = this.getLock(txh);
        lock.lock();
        try {
            boolean bl = this.data.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntryList getSlice(KeySliceQuery query, StoreTransaction txh) {
        Lock lock = this.getLock(txh);
        lock.lock();
        try {
            int end;
            Data datacp = this.data;
            int start = datacp.getIndex(query.getSliceStart());
            if (start < 0) {
                start = -start - 1;
            }
            if ((end = datacp.getIndex(query.getSliceEnd())) < 0) {
                end = -end - 1;
            }
            if (start < end) {
                MemoryEntryList result = new MemoryEntryList(end - start);
                for (int i = start; !(i >= end || query.hasLimit() && result.size() >= query.getLimit()); ++i) {
                    result.add(datacp.get(i));
                }
                MemoryEntryList memoryEntryList = result;
                return memoryEntryList;
            }
            EntryList.EmptyList emptyList = EntryList.EMPTY_LIST;
            return emptyList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void mutate(List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) {
        Object[] del;
        Object[] add;
        if (!additions.isEmpty()) {
            add = new Entry[additions.size()];
            int pos = 0;
            Iterator<Entry> iterator = additions.iterator();
            while (iterator.hasNext()) {
                Object e;
                add[pos] = e = iterator.next();
                ++pos;
            }
            Arrays.sort(add);
        } else {
            add = new Entry[]{};
        }
        if (!deletions.isEmpty()) {
            del = new Entry[deletions.size()];
            int pos = 0;
            for (StaticBuffer deletion : deletions) {
                Entry delEntry = StaticArrayEntry.of(deletion);
                if (Arrays.binarySearch(add, delEntry) >= 0) continue;
                del[pos++] = delEntry;
            }
            if (pos < deletions.size()) {
                del = (Entry[])Arrays.copyOf(del, pos);
            }
            Arrays.sort(del);
        } else {
            del = new Entry[]{};
        }
        Lock lock = this.getLock(txh);
        lock.lock();
        try {
            Entry[] olddata = this.data.array;
            int oldsize = this.data.size;
            Entry[] newdata = new Entry[oldsize + add.length];
            int i = 0;
            int iold = 0;
            int iadd = 0;
            int idel = 0;
            while (iold < oldsize) {
                int compare;
                Object e = olddata[iold];
                ++iold;
                if (iadd < add.length) {
                    compare = e.compareTo(add[iadd]);
                    if (compare >= 0) {
                        e = add[iadd];
                        ++iadd;
                        while (iadd < add.length && e.equals(add[iadd])) {
                            ++iadd;
                        }
                    }
                    if (compare > 0) {
                        --iold;
                    }
                }
                if (idel < del.length) {
                    compare = e.compareTo(del[idel]);
                    if (compare == 0) {
                        e = null;
                    }
                    if (compare >= 0) {
                        ++idel;
                    }
                }
                if (e == null) continue;
                newdata[i] = e;
                ++i;
            }
            while (iadd < add.length) {
                newdata[i] = add[iadd];
                ++i;
                ++iadd;
            }
            if ((double)i * 1.0 / (double)newdata.length < 0.66) {
                Entry[] tmpdata = newdata;
                newdata = new Entry[i];
                System.arraycopy(tmpdata, 0, newdata, 0, i);
            }
            this.data = new Data(newdata, i);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getLock(StoreTransaction txh) {
        Boolean txOn = txh.getConfiguration().getCustomOption(GraphDatabaseConfiguration.STORAGE_TRANSACTIONAL);
        if (null != txOn && txOn.booleanValue()) {
            if (this.lock == null) {
                ColumnValueStore columnValueStore = this;
                synchronized (columnValueStore) {
                    if (this.lock == null) {
                        this.lock = new ReentrantLock();
                    }
                }
            }
            return this.lock;
        }
        return NoLock.INSTANCE;
    }

    private static class Data {
        final Entry[] array;
        final int size;

        Data(Entry[] array, int size) {
            Preconditions.checkArgument((size >= 0 && size <= array.length ? 1 : 0) != 0);
            assert (this.isSorted());
            this.array = array;
            this.size = size;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        int getIndex(StaticBuffer column) {
            return Arrays.binarySearch(this.array, 0, this.size, StaticArrayEntry.of(column));
        }

        Entry get(int index) {
            return this.array[index];
        }

        boolean isSorted() {
            for (int i = 1; i < this.size; ++i) {
                if (this.array[i].compareTo(this.array[i - 1]) > 0) continue;
                return false;
            }
            return true;
        }
    }

    private static class MemoryEntryList
    extends ArrayList<Entry>
    implements EntryList {
        public MemoryEntryList(int size) {
            super(size);
        }

        @Override
        public Iterator<Entry> reuseIterator() {
            return this.iterator();
        }

        @Override
        public int getByteSize() {
            int size = 48;
            for (Entry e : this) {
                size += 40 + e.length();
            }
            return size;
        }
    }
}

