/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.LoggableTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class IndexTransaction
implements BaseTransaction,
LoggableTransaction {
    private static final int DEFAULT_OUTER_MAP_SIZE = 3;
    private static final int DEFAULT_INNER_MAP_SIZE = 5;
    private final IndexProvider index;
    private final BaseTransaction indexTx;
    private final KeyInformation.IndexRetriever keyInformations;
    private final Duration maxWriteTime;
    private Map<String, Map<String, IndexMutation>> mutations;

    public IndexTransaction(IndexProvider index, KeyInformation.IndexRetriever keyInformations, BaseTransactionConfig config, Duration maxWriteTime) throws BackendException {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkNotNull((Object)keyInformations);
        this.index = index;
        this.keyInformations = keyInformations;
        this.indexTx = index.beginTransaction(config);
        Preconditions.checkNotNull((Object)this.indexTx);
        this.maxWriteTime = maxWriteTime;
        this.mutations = new HashMap<String, Map<String, IndexMutation>>(3);
    }

    public void add(String store, String docid, IndexEntry entry, boolean isNew) {
        this.getIndexMutation(store, docid, isNew, false).addition(new IndexEntry(entry.field, entry.value, entry.getMetaData()));
    }

    public void add(String store, String docid, String key, Object value, boolean isNew) {
        this.getIndexMutation(store, docid, isNew, false).addition(new IndexEntry(key, value));
    }

    public void delete(String store, String docid, String key, Object value, boolean deleteAll) {
        this.getIndexMutation(store, docid, false, deleteAll).deletion(new IndexEntry(key, value));
    }

    private IndexMutation getIndexMutation(String store, String docid, boolean isNew, boolean isDeleted) {
        IndexMutation m;
        Map<String, IndexMutation> storeMutations = this.mutations.get(store);
        if (storeMutations == null) {
            storeMutations = new HashMap<String, IndexMutation>(5);
            this.mutations.put(store, storeMutations);
        }
        if ((m = storeMutations.get(docid)) == null) {
            m = new IndexMutation(isNew, isDeleted);
            storeMutations.put(docid, m);
        } else if (isNew && m.isDeleted()) {
            m.resetDelete();
            assert (!m.isNew() && !m.isDeleted());
        }
        return m;
    }

    public void register(String store, String key, KeyInformation information) throws BackendException {
        this.index.register(store, key, information, this.indexTx);
    }

    public List<String> query(IndexQuery query) throws BackendException {
        return this.index.query(query, this.keyInformations, this.indexTx);
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query) throws BackendException {
        return this.index.query(query, this.keyInformations, this.indexTx);
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents) throws BackendException {
        this.index.restore(documents, this.keyInformations, this.indexTx);
    }

    @Override
    public void commit() throws BackendException {
        this.flushInternal();
        this.indexTx.commit();
    }

    @Override
    public void rollback() throws BackendException {
        this.mutations = null;
        this.indexTx.rollback();
    }

    private void flushInternal() throws BackendException {
        if (this.mutations != null && !this.mutations.isEmpty()) {
            for (Map<String, IndexMutation> store : this.mutations.values()) {
                for (IndexMutation mut : store.values()) {
                    mut.consolidate();
                }
            }
            BackendOperation.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    IndexTransaction.this.index.mutate(IndexTransaction.this.mutations, IndexTransaction.this.keyInformations, IndexTransaction.this.indexTx);
                    return true;
                }

                public String toString() {
                    return "IndexMutation";
                }
            }, this.maxWriteTime);
            this.mutations = null;
        }
    }

    @Override
    public void logMutations(DataOutput out) {
        VariableLong.writePositive(out, this.mutations.size());
        for (Map.Entry<String, Map<String, IndexMutation>> store : this.mutations.entrySet()) {
            out.writeObjectNotNull(store.getKey());
            VariableLong.writePositive(out, store.getValue().size());
            for (Map.Entry<String, IndexMutation> doc : store.getValue().entrySet()) {
                out.writeObjectNotNull(doc.getKey());
                IndexMutation mut = doc.getValue();
                out.putByte((byte)(mut.isNew() ? 1 : (mut.isDeleted() ? 2 : 0)));
                List adds = mut.getAdditions();
                VariableLong.writePositive(out, adds.size());
                for (IndexEntry add : adds) {
                    this.writeIndexEntry(out, add);
                }
                List dels = mut.getDeletions();
                VariableLong.writePositive(out, dels.size());
                for (IndexEntry del : dels) {
                    this.writeIndexEntry(out, del);
                }
            }
        }
    }

    private void writeIndexEntry(DataOutput out, IndexEntry entry) {
        out.writeObjectNotNull(entry.field);
        out.writeClassAndObject(entry.value);
    }
}

