/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;

public class CassandraHelper {
    public static List<ByteBuffer> convert(List<StaticBuffer> keys) {
        ArrayList<ByteBuffer> requestKeys = new ArrayList<ByteBuffer>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            requestKeys.add(keys.get(i).asByteBuffer());
        }
        return requestKeys;
    }

    public static <E> EntryList makeEntryList(final Iterable<E> entries, final StaticArrayEntry.GetColVal<E, ByteBuffer> getter, final StaticBuffer lastColumn, final int limit) {
        return StaticArrayEntryList.ofByteBuffer((Iterable)new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.filter(entries.iterator(), new FilterResultColumns(lastColumn, limit, getter));
            }
        }, getter);
    }

    public static <E> Iterator<Entry> makeEntryIterator(Iterable<E> entries, final StaticArrayEntry.GetColVal<E, ByteBuffer> getter, StaticBuffer lastColumn, int limit) {
        return Iterators.transform((Iterator)Iterators.filter(entries.iterator(), new FilterResultColumns(lastColumn, limit, getter)), (Function)new Function<E, Entry>(){

            @Nullable
            public Entry apply(@Nullable E e) {
                return StaticArrayEntry.ofByteBuffer(e, (StaticArrayEntry.GetColVal)getter);
            }
        });
    }

    public static KeyRange transformRange(Range<Token> range) {
        return CassandraHelper.transformRange((Token)range.left, (Token)range.right);
    }

    public static KeyRange transformRange(Token leftKeyExclusive, Token rightKeyInclusive) {
        byte[] rightTokenValue;
        if (!(leftKeyExclusive instanceof BytesToken)) {
            throw new UnsupportedOperationException();
        }
        assert (rightKeyInclusive instanceof BytesToken);
        BytesToken l = (BytesToken)leftKeyExclusive;
        BytesToken r = (BytesToken)rightKeyInclusive;
        byte[] leftTokenValue = l.getTokenValue();
        Preconditions.checkArgument((leftTokenValue.length == (rightTokenValue = r.getTokenValue()).length ? 1 : 0) != 0, (Object)"Tokens have unequal length");
        int tokenLength = leftTokenValue.length;
        byte[][] tokens = new byte[][]{leftTokenValue, rightTokenValue};
        byte[][] plusOne = new byte[2][tokenLength];
        for (int j = 0; j < 2; ++j) {
            boolean carry = true;
            for (int i = tokenLength - 1; i >= 0; --i) {
                byte b = tokens[j][i];
                if (carry) {
                    b = (byte)(b + 1);
                    carry = false;
                }
                if (b == 0) {
                    carry = true;
                }
                plusOne[j][i] = b;
            }
        }
        StaticArrayBuffer lb = StaticArrayBuffer.of((byte[])plusOne[0]);
        StaticArrayBuffer rb = StaticArrayBuffer.of((byte[])plusOne[1]);
        Preconditions.checkArgument((lb.length() == tokenLength ? 1 : 0) != 0, (Object)lb.length());
        Preconditions.checkArgument((rb.length() == tokenLength ? 1 : 0) != 0, (Object)rb.length());
        return new KeyRange((StaticBuffer)lb, (StaticBuffer)rb);
    }

    private static class FilterResultColumns<E>
    implements Predicate<E> {
        private int count = 0;
        private final int limit;
        private final StaticBuffer lastColumn;
        private final StaticArrayEntry.GetColVal<E, ByteBuffer> getter;

        private FilterResultColumns(StaticBuffer lastColumn, int limit, StaticArrayEntry.GetColVal<E, ByteBuffer> getter) {
            this.limit = limit;
            this.lastColumn = lastColumn;
            this.getter = getter;
        }

        public boolean apply(@Nullable E e) {
            assert (e != null);
            if (this.count >= this.limit || BufferUtil.equals((StaticBuffer)this.lastColumn, (ByteBuffer)((ByteBuffer)this.getter.getColumn(e)))) {
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

