/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJETx;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeySelector;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJEKeyValueStore
implements OrderedKeyValueStore {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJEKeyValueStore.class);
    private static final StaticBuffer.Factory<DatabaseEntry> ENTRY_FACTORY = new StaticBuffer.Factory<DatabaseEntry>(){

        public DatabaseEntry get(byte[] array, int offset, int limit) {
            return new DatabaseEntry(array, offset, limit - offset);
        }
    };
    private final Database db;
    private final String name;
    private final BerkeleyJEStoreManager manager;
    private boolean isOpen;

    public BerkeleyJEKeyValueStore(String n, Database data, BerkeleyJEStoreManager m) {
        this.db = data;
        this.name = n;
        this.manager = m;
        this.isOpen = true;
    }

    public DatabaseConfig getConfiguration() throws BackendException {
        try {
            return this.db.getConfig();
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    private static final Transaction getTransaction(StoreTransaction txh) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        return ((BerkeleyJETx)txh).getTransaction();
    }

    public synchronized void close() throws BackendException {
        try {
            if (this.isOpen) {
                this.db.close();
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        if (this.isOpen) {
            this.manager.removeDatabase(this);
        }
        this.isOpen = false;
    }

    public StaticBuffer get(StaticBuffer key, StoreTransaction txh) throws BackendException {
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        try {
            DatabaseEntry dbkey = (DatabaseEntry)key.as(ENTRY_FACTORY);
            DatabaseEntry data = new DatabaseEntry();
            log.trace("db={}, op=get, tx={}", (Object)this.name, (Object)txh);
            OperationStatus status = this.db.get(tx, dbkey, data, BerkeleyJEKeyValueStore.getLockMode(txh));
            if (status == OperationStatus.SUCCESS) {
                return BerkeleyJEKeyValueStore.getBuffer(data);
            }
            return null;
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws BackendException {
        return this.get(key, txh) != null;
    }

    public void acquireLock(StaticBuffer key, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        if (BerkeleyJEKeyValueStore.getTransaction(txh) == null) {
            log.warn("Attempt to acquire lock with transactions disabled");
        }
    }

    public RecordIterator<KeyValueEntry> getSlice(KVQuery query, StoreTransaction txh) throws BackendException {
        log.trace("beginning db={}, op=getSlice, tx={}", (Object)this.name, (Object)txh);
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        Cursor cursor = null;
        StaticBuffer keyStart = query.getStart();
        StaticBuffer keyEnd = query.getEnd();
        KeySelector selector = query.getKeySelector();
        final ArrayList<KeyValueEntry> result = new ArrayList<KeyValueEntry>();
        try {
            StaticBuffer key;
            DatabaseEntry foundKey = (DatabaseEntry)keyStart.as(ENTRY_FACTORY);
            DatabaseEntry foundData = new DatabaseEntry();
            cursor = this.db.openCursor(tx, null);
            OperationStatus status = cursor.getSearchKeyRange(foundKey, foundData, BerkeleyJEKeyValueStore.getLockMode(txh));
            while (status == OperationStatus.SUCCESS && (key = BerkeleyJEKeyValueStore.getBuffer(foundKey)).compareTo((Object)keyEnd) < 0) {
                if (selector.include(key)) {
                    result.add(new KeyValueEntry(key, BerkeleyJEKeyValueStore.getBuffer(foundData)));
                }
                if (selector.reachedLimit()) break;
                status = cursor.getNext(foundKey, foundData, BerkeleyJEKeyValueStore.getLockMode(txh));
            }
            log.trace("db={}, op=getSlice, tx={}, resultcount={}", new Object[]{this.name, txh, result.size()});
            RecordIterator<KeyValueEntry> recordIterator = new RecordIterator<KeyValueEntry>(){
                private final Iterator<KeyValueEntry> entries;
                {
                    this.entries = result.iterator();
                }

                public boolean hasNext() {
                    return this.entries.hasNext();
                }

                public KeyValueEntry next() {
                    return this.entries.next();
                }

                public void close() {
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return recordIterator;
        }
        catch (Exception e) {
            throw new PermanentBackendException((Throwable)e);
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception e) {
                throw new PermanentBackendException((Throwable)e);
            }
        }
    }

    public Map<KVQuery, RecordIterator<KeyValueEntry>> getSlices(List<KVQuery> queries, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void insert(StaticBuffer key, StaticBuffer value, StoreTransaction txh) throws BackendException {
        this.insert(key, value, txh, true);
    }

    public void insert(StaticBuffer key, StaticBuffer value, StoreTransaction txh, boolean allowOverwrite) throws BackendException {
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        try {
            log.trace("db={}, op=insert, tx={}", (Object)this.name, (Object)txh);
            OperationStatus status = allowOverwrite ? this.db.put(tx, (DatabaseEntry)key.as(ENTRY_FACTORY), (DatabaseEntry)value.as(ENTRY_FACTORY)) : this.db.putNoOverwrite(tx, (DatabaseEntry)key.as(ENTRY_FACTORY), (DatabaseEntry)value.as(ENTRY_FACTORY));
            if (status != OperationStatus.SUCCESS) {
                if (status == OperationStatus.KEYEXIST) {
                    throw new PermanentBackendException("Key already exists on no-overwrite.");
                }
                throw new PermanentBackendException("Could not write entity, return status: " + status);
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public void delete(StaticBuffer key, StoreTransaction txh) throws BackendException {
        log.trace("Deletion");
        Transaction tx = BerkeleyJEKeyValueStore.getTransaction(txh);
        try {
            log.trace("db={}, op=delete, tx={}", (Object)this.name, (Object)txh);
            OperationStatus status = this.db.delete(tx, (DatabaseEntry)key.as(ENTRY_FACTORY));
            if (status != OperationStatus.SUCCESS) {
                throw new PermanentBackendException("Could not remove: " + status);
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static StaticBuffer getBuffer(DatabaseEntry entry) {
        return new StaticArrayBuffer(entry.getData(), entry.getOffset(), entry.getOffset() + entry.getSize());
    }

    private static LockMode getLockMode(StoreTransaction txh) {
        return ((BerkeleyJETx)txh).getLockMode();
    }
}

