/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.berkeleyje;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.BerkeleyStorageSetup;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphTest;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyGraphTest
extends TitanGraphTest {
    @Rule
    public TestName methodNameRule = new TestName();
    private static final Logger log = LoggerFactory.getLogger(BerkeleyGraphTest.class);

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration mcfg = BerkeleyStorageSetup.getBerkeleyJEConfiguration();
        String methodName = this.methodNameRule.getMethodName();
        if (methodName.equals("testConsistencyEnforcement")) {
            BerkeleyJEStoreManager.IsolationLevel iso = BerkeleyJEStoreManager.IsolationLevel.SERIALIZABLE;
            log.debug("Forcing isolation level {} for test method {}", (Object)iso, (Object)methodName);
            mcfg.set(BerkeleyJEStoreManager.ISOLATION_LEVEL, (Object)iso.toString(), new String[0]);
        } else {
            BerkeleyJEStoreManager.IsolationLevel iso = null;
            if (mcfg.has(BerkeleyJEStoreManager.ISOLATION_LEVEL, new String[0])) {
                iso = (BerkeleyJEStoreManager.IsolationLevel)ConfigOption.getEnumValue((String)((String)mcfg.get(BerkeleyJEStoreManager.ISOLATION_LEVEL, new String[0])), BerkeleyJEStoreManager.IsolationLevel.class);
            }
            log.debug("Using isolation level {} (null means adapter default) for test method {}", iso, (Object)methodName);
        }
        return mcfg.getConfiguration();
    }

    public void testConsistencyEnforcement() {
        BerkeleyJEStoreManager.IsolationLevel effective = (BerkeleyJEStoreManager.IsolationLevel)ConfigOption.getEnumValue((String)((String)this.config.get(ConfigElement.getPath((ConfigElement)BerkeleyJEStoreManager.ISOLATION_LEVEL, (String[])new String[0]), String.class)), BerkeleyJEStoreManager.IsolationLevel.class);
        Preconditions.checkState((boolean)BerkeleyJEStoreManager.IsolationLevel.SERIALIZABLE.equals((Object)effective));
        super.testConsistencyEnforcement();
    }

    protected boolean isLockingOptimistic() {
        return false;
    }

    public void testConcurrentConsistencyEnforcement() {
    }

    @Test
    public void testIDBlockAllocationTimeout() {
        this.config.set("ids.authority.wait-time", (Object)Duration.of(0L, ChronoUnit.NANOS));
        this.config.set("ids.renew-timeout", (Object)Duration.of(1L, ChronoUnit.MILLIS));
        this.close();
        TitanCleanup.clear((TitanGraph)this.graph);
        this.open(this.config);
        try {
            this.graph.addVertex(new Object[0]);
            Assert.fail();
        }
        catch (TitanException titanException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.graph.isOpen());
        this.close();
        this.open(this.config);
        Assert.assertEquals((long)0L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
    }
}

