(ns neo4j-clj.repl
  (:require [neo4j-clj.core :refer [defquery disconnect get-session execute with-transaction with-retry]]
            [neo4j-clj.in-memory :refer [create-in-memory-connection]])
  (:import (java.time LocalTime))
  )



(defquery create-test-user
          "CREATE (u:TestUser $user)-[:SELF {reason: \"to test\"}]->(u)")

(defquery get-test-users-by-name
          "MATCH (u:TestUser {name: $name})
           RETURN u.name as name, u.role as role, u.age as age, u.smokes as smokes, u.now as now")

(defquery get-test-users
          "MATCH (u:TestUser)
           RETURN u.name as name, u.role as role, u.age as age, u.smokes as smokes, u.now as now")

(defquery get-test-users-relationship
          "MATCH (u:TestUser {name: $name})-[s:SELF]->()
           RETURN collect(u) as ucoll, collect(s) as scoll")

(defquery delete-test-user-by-name
          "MATCH (u:TestUser {name: $name})
           DETACH DELETE u")

#_;
    (def temp-db (create-in-memory-connection))

#_;
    (with-transaction temp-db tx
                         (create-test-user tx {:user {:name "Luke Skywalker" :age 43}})
                         (create-test-user tx {:user {:name "John Johnson"}})
                         #_(throw (Exception. "my exception message"))
                         (create-test-user tx {:user {:name "Marry Poppins"}}))

#_;
(with-open [session (get-session temp-db)]
  (doall (get-test-users session )))

#_;
    (disconnect temp-db)

#_;
    (def dummy-user
      {:name "MyTestUser"
       :role ["Dummy" "Mock" "Fake"]
       :age (double 42.141)
       :now (LocalTime/now)
       :smokes true})

#_;
    (with-open [session (get-session temp-db)]
      (create-test-user session {:user dummy-user}))

#_;
    (with-open [session (get-session temp-db)]
      (doall (get-test-users-by-name session {:name "MyTestUser"})))

#_;
    (with-open [session (get-session temp-db)]
      (doall (delete-test-user-by-name session {:name "MyTestUser"})))