# stashapi-jar

STASH API Library for accessing STASH services

## Installation

For the library to link with other projects, download the JAR from the releases section of this page
or get from Clojars.org

    :dependencies [[global.stash/stashapi-jar]]

## Usage

See the online API overview and reference in the Help Center from your STASH account. 

To use the API, you must obtain an API ID and API PW from the account settings page of your STASH account.

Most of the API functions take a single parameter, 'options', a map of the key/value pairs needed for that function to work.
Review the source and destination identifiers on the API reference page to determine what key/value pairs  

## Examples

Checks a connection to your STASH account on www.stashbusiness.com using your API ID of '12345' and API PW of '12345'

    (let [options {:id "12345" :pw "12345" :endpoint "https://www.stashbusiness.com" :verbose false}]
        (is (= true (checkvaultconnection options)))
    )
    
Gets information for a file in your STASH account with name "test.txt" in the "My Home\Documents" directory:

    (let [options {:srcId (str "fileName=test.txt,folderNames=My Home|Documents") :id "12345" :pw "12345" :endpoint "https://www.stashbusiness.com" :verbose false}
        response (getfileinfo options)]
    )
Note that for folderNames and destFolderNames, directory names must be separated by the pipe "|" character.

## License

Copyright © 2021 STASH Global, Inc

This program and the accompanying materials are made available under the
terms of the MIT License - see License file.
