package org.conjode.java;

import java.io.Serializable;

/**
 * Created by smanvi on 11/18/16.
 */
public class Customer implements Serializable {

    String firstName;
    String lastName;
    String address;
    String state;
    int age;
    int ssn;

    //Needed for serialization
    public Customer() {
    }

    public Customer(String firstName, String lastName, String address, int age) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.address = address;
        this.age = age;
    }

    public Customer(String firstName, String lastName, int ssn) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.ssn = ssn;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "Customer{" +
                "firstName='" + firstName + '\'' +
                ", lastName='" + lastName + '\'' +
                ", address='" + address + '\'' +
                ", state='" + state + '\'' +
                ", age=" + age +
                ", ssn=" + ssn +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Customer customer = (Customer) o;

        if (age != customer.age) return false;
        if (ssn != customer.ssn) return false;
        if (firstName != null ? !firstName.equals(customer.firstName) : customer.firstName != null)
            return false;
        if (lastName != null ? !lastName.equals(customer.lastName) : customer.lastName != null)
            return false;
        if (address != null ? !address.equals(customer.address) : customer.address != null)
            return false;
        return state != null ? state.equals(customer.state) : customer.state == null;
    }

    @Override
    public int hashCode() {
        int result = firstName != null ? firstName.hashCode() : 0;
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (address != null ? address.hashCode() : 0);
        result = 31 * result + (state != null ? state.hashCode() : 0);
        result = 31 * result + age;
        result = 31 * result + ssn;
        return result;
    }
}
