(ns conjode.query
  (:require [conjode.util :as util :refer :all]
            [conjode.core :as c :refer :all]
            [conjode.internal :as i :refer :all])
  (:import [org.apache.geode.cache.client ClientCache ClientCacheFactory]
           [org.apache.geode.cache Region]
           (org.apache.geode.cache.query QueryService Query)))


(defn execute-query
  "Executes the given query"
  [query-str ^ClientCache geode-client]
  (let [^QueryService query-service (.getQueryService geode-client)
        ^Query query (.newQuery query-service query-str)]
    (.execute query)))
